#include <Vioprotocol.h>
#include <rasterops.h>
#include "Vgts.h"
#include "sdf.h"
#include "vgt.h"
#include "arc.h"

Arc *arclist = NULL;


Circle(cx, cy, r, clip)
  short cx, cy, r;
  register struct SubView *clip;
  {
    register short ymin, ymax;
    register short dx, dy;
    int rsq = r * r + r;

    ymin = cy - r;
    ymax = cy + r;
    /* easy clip: if it's all inside, use a fast algorithm */
    if (ymin >= clip->ScreenYmin && ymax <= clip->ScreenYmax &&
	cx-r >= clip->ScreenXmin && cx+r <= clip->ScreenXmax)
      {
	QuickCircle(cx, cy, r);
	return;
      }

    /* cut the circle into quadrants and treat it as a polyarc */
    arclist = NULL;  /* for safety */
    StoreArc(ULARC, cx, cy-r, cx-r, cy, cx, cy, r);
    StoreArc(URARC, cx, cy-r, cx+r, cy, cx, cy, r);
    StoreArc(LRARC, cx+r, cy, cx, cy+r, cx, cy, r);
    StoreArc(LLARC, cx-r, cy, cx, cy+r, cx, cy, r);

    DrawArcs(arclist, clip);
    CleanOutArcs(arclist);
    arclist = NULL;
  }


QuickCircle(cx, cy, r)
  short cx, cy, r;
  {
    register short x, y;
    register int xsq, ysq, savesq, rsq;

    rsq = r*r + r;  /* limiting circle of radius approx. (r + 1/2) */
    x = xsq = 0;
    y = -r;
    ysq = y*y;

    while (y <= 0)
      {
	while (xsq + ysq <= rsq)
	  { /* hit all 4 quadrants at once */
	    Plot(cx-x, cy+y);  Plot(cx+x, cy+y);
	    Plot(cx-x, cy-y);  Plot(cx+x, cy-y);
	    savesq = xsq;
	    xsq += (x<<1) + 1;	  /* (x+1)**2 = x**2 + 2x + 1 */
	    x++;
	  }
	xsq = savesq;
	x--;  /* overshot by 1 pixel, back off and drop down */
	ysq += (y<<1) + 1;  /* y is negative, this DECREASES ysq */
	y++;
      }
  }


StoreArc(type, x0, y0, x1, y1, cx, cy, r)
  short type, x0, y0, x1, y1, cx, cy, r;
  {
    register Arc *arc;

    arc = (Arc *) malloc(sizeof(Arc));

    arc->type = type;
    arc->x0 = x0;
    arc->y0 = y0;
    arc->x1 = x1;
    arc->y1 = y1;
    arc->cx = cx;
    arc->cy = cy;
    arc->r = r;
    arc->rsq = r*r + r;  /* rsq for a radius about 1/2 pixel too big */

    arc->next = arclist;
    arclist = arc;
  }


Arcdata circledata[5];

FillCircle(cx, cy, r, pattern, clip)
  short cx, cy, r;
  register struct SubView *clip;
  {
    register short ymin, ymax;
    register short dx, dy;
    int rsq = r * r + r;
    register int i;

    ymin = cy - r;
    ymax = cy + r;
    /* easy clip: if it's all inside, use a fast algorithm */
    if (ymin >= clip->ScreenYmin && ymax <= clip->ScreenYmax &&
	cx-r >= clip->ScreenXmin && cx+r <= clip->ScreenXmax)
      {
	QuickFillCircle(cx, cy, r, pattern);
	return;
      }

    /* cut the circle into quadrants and treat it as a polyarc */
    PutCirclePoint(0, URARC, r,  0, r, 0, 0);
    PutCirclePoint(1, LRARC, r,  r, 0,  0, 0);
    PutCirclePoint(2, LLARC, r,  0, -r,  0, 0);
    PutCirclePoint(3, ULARC, r,  -r, 0, 0, 0);
    PutCirclePoint(4, LINE, 0,   0, r, 0, 0);

    FillPolyarc(5, circledata, pattern, cx, cy, 0, clip);
  }


extern short fill_area_color, fill_area_opacity;

/* Circle, where clipping is not required */
QuickFillCircle(cx, cy, r, pattern)
  short cx, cy, r;
  short *pattern;
  {
    register short x, y;
    register int xsq, ysq, savesq, rsq;

    /* set the framebuffer function once and for all */
    SetFillFunction(fill_area_color, fill_area_opacity);

    rsq = r*r + r;  /* limiting circle of radius approx. (r + 1/2) */
    x = xsq = 0;
    y = -r;
    ysq = y*y;

    while (y <= 0)
      {
	while (xsq + ysq <= rsq)
	  { /* hit all 4 quadrants at once */
	    savesq = xsq;
	    xsq += (x<<1) + 1;	  /* (x+1)**2 = x**2 + 2x + 1 */
	    x++;
	  }
	xsq = savesq;
	x--;  /* overshot by 1 pixel, back off and fill that row */
	FillRow(cy+y, cx-x, cx+x, pattern);
	FillRow(cy-y, cx-x, cx+x, pattern);
	ysq += (y<<1) + 1;  /* y is negative, this DECREASES ysq */
	y++;
      }
  }


PutCirclePoint(index, type, r, x, y, cx, cy)
  short index, type, r, x, y, cx, cy;
  {
    register Arcdata *p = &circledata[index];

    p->type = type;
    p->r = r;
    p->x = x;
    p->y = y;
    p->cx = cx;
    p->cy = cy;
  }
