#include <ctype.h>
#include <Vio.h>
#include <Vnet.h>
#include <Vspinlock.h>

extern File      *OpenTcp();
extern ProcessId  FileServer();
extern InstanceId FileId();
extern SystemCode SetInstanceOwner();
extern ProcessId  Create();
extern ProcessId  Ready();
extern char      *ErrorString();

#define AnyPort		0
#define AnyAddress	0
#define TelnetPort	23
#define Passive		0

#define HelperPriority  0
#define HelperStackSize 4096

extern SystemCode StartTerminalAgent();
extern SystemCode StartInternetServer();


InitConnection(netOut)
    File *netOut;
  {
    SystemCode error;
    File *netIn;
    
    netIn  = OpenFile(FileServer(netOut),
		      FileId(netOut)+1,
		      FREAD|FRELEASE_ON_CLOSE,&error);
    if( error != OK )
	fprintf(stderr,"***error opening readable side of Tcp: %s\n",
		       ErrorString(error));
    else
      {
#ifdef DEBUG
        fprintf(stderr,"opened TCP connection\n");fflush(stderr);
#endif DEBUG

        if( (error = StartTerminalAgent(netIn,netOut)) != OK )
            fprintf(stderr,"***error starting terminal agent: %s\n",
		           ErrorString(error));
      }

  }


AcceptConnection()
  {
    SystemCode error;
    ProcessId  helperPid;
    File       *netOut;
    
#ifdef DEBUG
    fprintf(stderr,"Starting telnet server ...\n");
    fflush(stderr);
#endif DEBUG

    netOut = OpenTcp( TelnetPort, AnyPort, AnyAddress,
		      Passive, DefaultTcpSecurity, DefaultTcpPrecedence,
		      &error);
    if( error != OK )
      {
	fprintf(stderr,"***error in OpenTcp: %s\n",ErrorString(error));
	return error;
      }
#ifdef DEBUG
    fprintf(stderr,"*** connection received ***\n");
    fflush(stderr);
#endif DEBUG

    /* start up the process */
    helperPid = Create(HelperPriority,InitConnection,HelperStackSize);
    if( helperPid == 0 )
      {
	fprintf(stderr,"***error creating helper process\n");
	return INTERNAL_ERROR;
      }

    if( (error=SetInstanceOwner(FileServer(netOut),FileId(netOut),helperPid))
			 != OK )
      {
	fprintf(stderr,"***error giving helper input ownership: %s\n",
		       ErrorString(error));
	return error;
      }
    if( (error=SetInstanceOwner(FileServer(netOut),FileId(netOut)+1,helperPid))
			 != OK )
      {
	fprintf(stderr,"***error giving helper output ownership: %s\n",
		       ErrorString(error));
	return error;
      }

    if( Ready(helperPid,1,netOut) != helperPid )
      {
	fprintf(stderr,"***error readying helper process\n");
	return INTERNAL_ERROR;
      }
    
    return OK;
  }


main()
  {
    if( GetPid(INTERNET_SERVER,LOCAL_PID) == 0 )
      if( StartInternetServer() != OK )
          abort();

    while( AcceptConnection() == OK );
  }
