#include <Venviron.h>
#include <Vioprotocol.h>
#include <Vnet.h>

extern ProcessId ExecProgram();
extern char	*ErrorString();
extern ProcessId Send();

SystemCode StartInternetServer()
  {
    static char *internetArgs[] = { "internetserver", NULL };
    ProcessId internetPid;
    SystemCode error;

    fprintf(stderr,"Loading internet server...\n");
    fflush(stderr);
    internetPid = ExecProgram(internetArgs,0,NULL,NULL,NULL,&error);
    if( error != OK )
      {
	fprintf(stderr,"**** Error loading internet server: %s\n",
		       ErrorString(error));
	return error;
      }
    WaitServer(internetPid);
    return OK;
  }

WaitServer(pid)
    ProcessId pid;
  {
    Message queryMsg;
    NQueryFileRequest *queryRequest = (NQueryFileRequest *) queryMsg;
    
    queryRequest->requestcode = NQUERY_FILE;
    queryRequest->type = IPtype;
    queryRequest->nameindex = 0;
    queryRequest->namecontextid = 0;
    queryRequest->nameptr = "Ip";
    queryRequest->namelength = 2;
    
    Send(queryMsg,pid);
  }
