/*
 *  routines for the RTS processes writing to the net
 */

#include <Vio.h>

#include <telnet.h>
#include <stsio.h>
#include <rtsdefs.h>

#define FilterOutputChar		\
  {					\
    if( Connection.out.afterCR )	\
      {					\
	Connection.out.afterCR = FALSE;	\
	if( ch != LF )			\
	    putchar(NUL);		\
      }					\
    switch( ch )			\
      {					\
	case IAC: putchar(IAC);		\
		  putchar(IAC);		\
		  break;		\
	case CR:  Connection.out.afterCR = TRUE; /* note NO break */ \
	default:  putchar(ch); break;	\
      }					\
  }



/* debugging aids */
#ifdef DEBUG
#undef putchar

int putchar(ch)
    int ch;
  {
    DebugTelnetByte(ch,1);
    return putc(ch,stdout);
  }
#endif DEBUG


int TelnetPutCharacter(ch)
    int ch;
  {
    AcquireGlobalSpinLock(Connection);

    FilterOutputChar

    ReleaseGlobalSpinLock(Connection);
    return ch;
  }


TelnetPutString(s)
    char *s;
  {
    int ch;

    AcquireGlobalSpinLock(Connection);

    while( (ch = *s++) != '\0' )
      {
	FilterOutputChar
      }

    ReleaseGlobalSpinLock(Connection);
  }


TelnetFlushOutput()
  {
    AcquireGlobalSpinLock(Connection);
    
    Flush(stdout);

    ReleaseGlobalSpinLock(Connection);
  }
