
/*
 *  routines for the RTS process reading from the net
 */

#include <Vio.h>
#include <Vspinlock.h>

#include <telnet.h>
#include <stsio.h>
#include <rtsdefs.h>

ConnectionStruct Connection = INITIAL_CONNECTION_STATE;


/* debugging aids */
#ifdef DEBUG
#undef getchar

static int getchar()
  {
    int ch = getc(stdin);
    DebugTelnetByte(ch,0);
    return ch;
  }
#endif DEBUG


TelnetNegotiateInitialOptions()
  {
    AcquireGlobalSpinLock(Connection);

    putchar(IAC);
    putchar(WILL);
    putchar(SUPPRESS_GO_AHEAD);
    Connection.serverState.suppressGA.changeRequested = TRUE;

    putchar(IAC);
    putchar(WILL);
    putchar(ECHO);
    Connection.serverState.echo.changeRequested = TRUE;

    ReleaseGlobalSpinLock(Connection);
  }

char AYTmessage[] = "\r\nV-System here\r\n";

ProcessCommand(noChars)
    boolean *noChars;
  {
    int option, ch;
    int command = getchar();

    *noChars = FALSE;
    switch( command )
      {
	case IAC:
	    return IAC;
	    break;
	case DO:
	case DONT:
	    option = getchar();
	    HandleOptionRequest(command,option);
	    *noChars = TRUE;
	    break;
	case WILL:
	case WONT:
	    option = getchar();
	    HandleOptionOffer(command,option);
	    *noChars = TRUE;
	    break;
	case AYT:
	    PutString(AYTmessage);
	    FlushOutput();
	    *noChars = TRUE;
	    break;
	case EC:
	    ch = DEL;
	    break;
	case EL:
	    ch = '\005';	   /* ^E */
	    Connection.in.buffer = '\025'; /* ^U */
	    break;
	case IP:
	    ch = '\036';	/* ^^ */
	    Connection.in.buffer = 'k';	/* k  */
	    break;
	    
	case SE:
	case SB:

	case AO:
	case DM:
	case BRK:
	case GA:
	case NOP:
	    *noChars = TRUE;
	    break;
	default:
	    *noChars = TRUE;
	    break;
      }
    return ch;
  }


int TelnetGetCharacter()
  {
    int ch;
    boolean noChars;

    if( Connection.in.buffer != '\0' )
      {
        ch = Connection.in.buffer;
	Connection.in.buffer = '\0';
      }
    else
	for( ;; )
	  {
	    ch = getchar();
	    if( Connection.in.afterCR )
	      {
		Connection.in.afterCR = FALSE;
		/*
		 *  discard (padding) NUL in CR-NUL, and
		 *  convert CR-LF to CR
		 */
		if( (ch == NUL) || (ch == LF) )
		    ch = getchar();
	      }
    
	    if( ch == CR )
		Connection.in.afterCR = TRUE;
	    else if( ch == IAC )
	      {
		ch = ProcessCommand(&noChars);
		if( noChars )
		    continue;
	      }
	    break;
	  }

    if( ch == EOF )
	exit(0);

    return ch;
  }

