/*
 *  telnet option handling
 */

#include <Vio.h>
#include <Vspinlock.h>

#include <telnet.h>
#include <rtsdefs.h>

#ifdef DEBUG
#undef putchar
#endif


OptionState *GetOption(opt,state)
    int       opt;
    EndState *state;
  {
    OptionState *returnState;
    static OptionState defaultState = CANT_DO;

    switch( opt )
      {
	case ECHO:
	    returnState = &(state->echo);
	    break;
	case SUPPRESS_GO_AHEAD:
	    returnState = &(state->suppressGA);
	    break;
	default:
	    state->dummyOption = defaultState;
	    returnState = &(state->dummyOption);
	    break;
      }
    return returnState;
  }

/* server-end options */

HandleOptionRequest(request,option)
    int request;
    int option;
  {
    OptionState *optionRecord;
    boolean requestedState = (request==DO);
    
    AcquireGlobalSpinLock(Connection);
    
    optionRecord = GetOption(option,&(Connection.serverState));

#ifdef DEBUG
    fprintf(stdout,"Option request: %s %d %d -> [ %d %d %d ]\r\n",
    		   requestedState?"DO  ":"DONT",
		   option,
		   ((int) optionRecord) - ((int) &(Connection.serverState)),
		   optionRecord->optionStatus,
		   optionRecord->changeRequested,
		   optionRecord->canHandle);
    fflush(stdout);
#endif

    if( requestedState && !(optionRecord->canHandle) )
      {
        putchar(IAC);
	putchar(WONT);
	putchar(option);
      }
    else if( requestedState != optionRecord->optionStatus )
      {
	optionRecord->optionStatus = requestedState;
	if( optionRecord->changeRequested )
	    optionRecord->changeRequested = FALSE;
	else
	  {
	    putchar(IAC);
	    putchar(WILL);
	    putchar(option);
	  }
	/* insert a switch( option ) for those that require special action */
      }
    
    ReleaseGlobalSpinLock(Connection);
  }

/* user-end options */

HandleOptionOffer(request,option)
    int request;
    int option;
  {
    OptionState *optionRecord;
    boolean requestedState = (request==WILL);
    
    AcquireGlobalSpinLock(Connection);
    
    optionRecord = GetOption(option,&(Connection.userState));

#ifdef DEBUG
    fprintf(stdout,"Option offer: %s %d %d -> [ %d %d %d ]\r\n",
    		   requestedState?"WILL":"WONT",
		   option,
		   ((int) optionRecord) - ((int) &(Connection.userState)),
		   optionRecord->optionStatus,
		   optionRecord->changeRequested,
		   optionRecord->canHandle);
    fflush(stdout);
#endif

    if( requestedState && !(optionRecord->canHandle) )
      {
        putchar(IAC);
	putchar(DONT);
	putchar(option);
      }
    else if( requestedState != optionRecord->optionStatus )
      {
	optionRecord->optionStatus = requestedState;
	if( optionRecord->changeRequested )
	    optionRecord->changeRequested = FALSE;
	else
	  {
	    putchar(IAC);
	    putchar(DO);
	    putchar(option);
	  }
	/* insert a switch( option ) for those that require special action */
      }
    
    ReleaseGlobalSpinLock(Connection);
  }


