/*
 *  definitions for I/O primitives used by STS and its derivatives: RTS
 *
 *  Cary Gray		Jan 1985
 *
 */

/* declarations for each version */

#ifdef STS
#define USE_STDIO
#endif STS

#ifdef RTS
#undef USE_STDIO
#endif



/* common definitions */

#ifdef USE_STDIO

#define PutCharacter(x) (putchar(x))
#define PutString(x)	(fputs(x,stdout))
#define GetCharacter() (getchar())
#define FlushOutput()	(Flush(stdout))
#define ResynchInput()	(Resynch(stdin))
#define LastInputException()	(Eof(stdin))

#endif USE_STDIO


/* RTS declaration */

#ifdef RTS

#define PutCharacter(x)	TelnetPutCharacter(x)
#define PutString(x)	TelnetPutString(x)
#define GetCharacter()	TelnetGetCharacter()
#define FlushOutput() TelnetFlushOutput()
#define ResynchInput()	(Resynch(stdin))
#define LastInputException()	(Eof(stdin))

extern int TelnetPutCharacter();
extern     TelnetPutString();
extern int TelnetGetCharacter();
extern     TelnetFlushOutput();

extern TelnetNegotiateInitialOptions();

#endif RTS
