/*
 * rtsdefs.h - common declaration for the Remote Terminal Server
 *
 */

#include <Vspinlock.h>


typedef int boolean;
#define TRUE  (!FALSE)
#define FALSE 0


/* option-related declarations */

#define CAN_DO  { FALSE, FALSE, TRUE }
#define CANT_DO { FALSE, FALSE, FALSE }

typedef struct {
    boolean optionStatus;
    boolean changeRequested;
    boolean canHandle;
  } OptionState;


typedef struct {
    OptionState suppressGA;
    OptionState echo;
    OptionState dummyOption;
  } EndState;

#define INITIAL_SERVER_STATE { CAN_DO, CAN_DO, CANT_DO }
#define INITIAL_USER_STATE { CAN_DO, CANT_DO, CANT_DO }

extern OptionState *GetOption();

/* connection declarations */

typedef struct {
    SpinLockType lock;
    struct {
	int buffer;
	boolean afterCR;
      } in;
    struct {
	boolean afterCR;
      } out;
    EndState serverState;
    EndState userState;
  } ConnectionStruct;

#define INITIAL_CONNECTION_STATE   { SpinLockUnlocked,		\
				     { '\0', FALSE },		\
				     { FALSE },			\
				     INITIAL_SERVER_STATE,	\
				     INITIAL_USER_STATE }

extern ConnectionStruct Connection;

