/********************************************************/
/*							*/
/*	       Simple Terminal Server			*/
/*							*/
/*		(C) COPYRIGHT 1983			*/
/*		BOARD OF TRUSTEES			*/
/*	LELAND STANFORD JUNIOR UNIVERSITY		*/
/*	  STANFORD, CA. 94305, U. S. A.			*/
/*							*/
/********************************************************/

/* pad.c - Pad routine redirections for TS line editing
 *
 *
 * Craig Dunwoody December 1983
 *
 */

/* purpose: to transform the use of pad routines into a
   standardized use of escape sequences.  */

#include "edit.h"

#include <stsio.h>

short TtyVGT = 0;


PadNewLine(pad)

  {
    register int i;

    PutCharacter('\r');
    PutCharacter('\n');
    for (i = 0 ; i < cursorPos.col ; i++)
      {
        PutCharacter('\033');
        if (!IsCadlinc) PutCharacter('[');
        PutCharacter('C');
      }
    FlushOutput();
    cursorPosDown;
  }


PadReturn(pad)

  {
    PutCharacter('\r');
    FlushOutput();
    cursorPos.col = 0;
  }


PadCursorBackward(pad)

  {
    PutCharacter(Control('H'));
    FlushOutput();
    cursorPosLeft;
  }


PadCursorForward(pad)

  {

    PutCharacter('\033');
    if (!IsCadlinc) PutCharacter('[');
    PutCharacter('C');
    FlushOutput();
    cursorPosRight;

  }


PadCursorUp(pad)

  {
    PutCharacter('\033');
    if (!IsCadlinc) PutCharacter('[');
    PutCharacter('A');
    FlushOutput();
    cursorPosUp;
  }


PadClearToEOL(pad)

  {
    PutCharacter('\033');
    if (!IsCadlinc) PutCharacter('[');
    PutCharacter('K');
    FlushOutput();
  }


PadPosition(pad, line, column)
  short line, column;
  {
	/* Since we can't know where the cursor really is, we must simulate
	 * absolute cursor addressing by moving the cursor relative to curpos.
	 */

    int dx = column - cursorPos.col , dy = line - cursorPos.row;

    if (dx > 0) for ( ; dx-- > 0 ; PadCursorForward(pad) );

    else if (dx < 0) for ( ; dx++ < 0 ; PadCursorBackward(pad) );

    if (dy > 0) for ( ; dy-- > 0 ; PadNewLine(pad) );

    else if (dy < 0) for ( ; dy++ < 0 ; PadCursorUp(pad) );

  }


PadPutChar(ch, pad)

  char ch;

  {

    if (cursorPos.col == Ncols)

      {
	PutCharacter('\\');
	cursorPos.col = 0;
	cursorPosDown;
      }

    PutCharacter(ch);

    FlushOutput();
    cursorPos.col++;
 
  }


PadPutString(string, pad)

  char *string;

  {
    while (*string != '\0')  PadPutChar(pad, *string++);
  }


PadGetCursor( pad, line, col )
  short *line, *col;
  {
	/*
	 * We can't know where the cursor really is, so we assume it is at
	 * line 1 and use relative cursor positioning.  Assumptions about
	 * the column are made elsewhere.
	 */

    *line = 1;
    *col = 3;	/* assume 1-character prompt, for now */
  }


PadGetSize( pad, length,  width )
  short *length, *width;
  {
	/*
	 * Return the length and width of a standard ANSI pad.
	 *
	 */

    *length = 24;
    *width = 79;

  }
