/********************************************************/
/*							*/
/*	       Simple Terminal Server			*/
/*							*/
/*		(C) COPYRIGHT 1983			*/
/*		BOARD OF TRUSTEES			*/
/*	LELAND STANFORD JUNIOR UNIVERSITY		*/
/*	  STANFORD, CA. 94305, U. S. A.			*/
/*							*/
/********************************************************/

/* init.c - Terminal Server Initialization
 *
 * Kenneth Brooks, Nov. 1983
 *
 * This provides the "main" program for the simple terminal server
 */

# include <Venviron.h>
# include <Vioprotocol.h>

extern ExecWatch();
extern ProcessId StsPid;	/* set in InitTs */
short Debug = 0;

/*
 * main:
 * Main routine for the ts package.
 * This routine sets up the ts process and any applications
 * processes; in this case, ExecWatch.
 */

main()
  {
    Message msg;
    ProcessId initpid;

    InitSts();

    /* ExecWatch plays a bit of the same role that the View Manager plays in
     * the VGTS world: it creates an initial exec and guarantees the existence
     * of at least one exec at all times: if it finds exec 0 dead, it will
     * create a new exec.
     */
    initpid = Create(10, ExecWatch, 512);
    Ready(initpid, 0);

    /*
     * The main server loop: wait for a message and take appropriate action,
     * forever.
     */
    while (1) GetMessage( 0, 0, msg );
 }


ProcessId execserver, myexecpid;
int myexec;

ExecWatch()
  {
    Message msg;
    SystemCode r;

    execserver = GetPid(EXEC_SERVER, LOCAL_PID);
    if (execserver == 0) 
      {
	printf("No exec server!"); 
	exit();
      }

    while (1)
      {
	/* instance id's of 0 because ts supports only one instance */
	myexec = CreateExec(execserver, StsPid, 0, StsPid, 0, StsPid, 0,
			0, 0, 0, &myexecpid, &r);
	if (r != OK)
	  {
	    printf("Can't create exec: %s", ErrorString(r));
	    exit();
	  }
	ReceiveSpecific(msg, myexecpid);
      }
  }
