/********************************************************/
/*							*/
/*	  Virtual Graphics Terminal Server		*/
/*							*/
/*		(C) COPYRIGHT 1983			*/
/*		BOARD OF TRUSTEES			*/
/*	LELAND STANFORD JUNIOR UNIVERSITY		*/
/*	  STANFORD, CA. 94305, U. S. A.			*/
/*							*/
/********************************************************/

/* edit.h - Global declarations for VGTS text editing
 *
 *
 * Craig Dunwoody December 1983
 *
 */


#include <Vio.h>
#include <Vioprotocol.h>
#include <Venviron.h>
#include <chars.h>
#include <Vtermagent.h>
#include "Vgts.h"
#include "pad.h"
#include "client.h"


#define PosEQ(p,q)	(p.row == q.row && p.col == q.col)
#define PosNE(p,q)	(p.row != q.row || p.col != q.col)
#define PosGT(p,q)	(p.row == q.row ? (p.col > q.col) : (p.row > q.row))
#define PosGE(p,q)	(p.row == q.row ? (p.col >= q.col) : (p.row > q.row))
#define PosLT(p,q)	(p.row == q.row ? (p.col < q.col) : (p.row < q.row))
#define PosLE(p,q)	(p.row == q.row ? (p.col <= q.col) : (p.row < q.row))


/* The character pointers in a Mark are absolute: if they are equal,
   the Marks are equal.  But if chunk pointers are then unequal, chaos! */
#define MarkEQ(a,b)	((a).cp == (b).cp)
#define MarkNEQ(a,b)	((a).cp != (b).cp)
#define Atend(m)	((m).cp == ebuf->endmark.cp)
#define Atstart(m)	((m).cp == ebuf->headmark.cp)
#define Settoend(m)	(m = ebuf->endmark)
#define Chunkend(chunk)	(chunk->text + chunk->length)

#define	padIndex	pad - TtyPadList
#define	VgtsPad		TtyPadList + TtyVGT


typedef TtyPadType *Padtype;

typedef enum editStatusCode

  {

    Nominal,
    AtTextStart,
    AtTextEnd,
    AtChunkStart,
    AtChunkEnd,
    NoSelection,
    NullText,
    MakeChunkFailure,
    OutOfMemory

  } EditStatusCode;


extern struct Client *client;
extern EditBuffer *ebuf;

extern struct Event *FreeEvents;

extern Padtype	pad;
extern short	TtyVGT;

extern short		MouseX, MouseY, MouseButtons;
extern Pos		mousepos;
extern Pos		cursorPos;

extern Mark		tempmark0, tempmark1, tempmark2;
extern short		Nrows, Ncols;
extern char		escsequence[];
extern Chunk		killbuffer;
extern short		Debug;
extern EditStatusCode	Status;

extern KeyTableEntry	DefaultMainKeyTable[];
extern KeyTableEntry	DefaultSelectionKeyTable[];
extern KeyTableEntry	DefaultEscKeyTable[];
extern KeyTableEntry	DefaultANSIKeyTable[];
extern KeyTableEntry	DefaultPFKeyTable[];
extern KeyTableEntry	DefaultQuoteKeyTable[];
extern KeyTableEntry	DefaultHiquoteKeyTable[];


#define	currow	ebuf->curpos.row
#define	curcol	ebuf->curpos.col
#define	headrow	ebuf->headpos.row
#define	headcol	ebuf->headpos.col


#define	MarkSetcursor(mark)	Setcursor(mark, Markpos(mark))

extern Mark	Makemark(),Posmark(),Rowmark(),Rowsend(),Backrows();
extern Mark	Findend(),BlockInsert();
extern Pos	Makepos(),Markpos();
extern int	ShowChar(),CountWidth();
extern int	Markcol();
extern int	TextString();

extern Chunk 	BlockDelete(),CutSubchunk(),CopySection();
extern Chunk	MakeChunk(),StringText();
extern Mark 	*Firstmark(),*Nextmark();

extern EditStatusCode	SelfInsert(), DeleteForward(), Forespace(), Backspace();
extern EditStatusCode	ForwardWord(), BackWord(), Upaline(), Downaline();
extern EditStatusCode	TextInsertChar(), TextDeleteForward();
extern EditStatusCode	SplitChunk(), Advance(), Retract();
extern EditStatusCode	ExchangeSelection(), KillSelection();
extern EditStatusCode	Kill();

extern BOOLEAN		AtWordStart(), AtWordEnd();

extern EditBuffer	*CreateBuffer();

extern EditStatusCode	AddMark(), AddKeyTable();
extern KeyTableRec	*GetKeyTable();
extern OpCode		GetOp();

extern int		Charsize();
extern unsigned char	*Charstring();

extern short		popup();

/* character modifiers used by ved */
#define	Control(c)	(c - '@')

/* special keys on Cadlinc keyboards */
#define CadlincPF1	0366
#define CadlincPF2	0367
#define CadlincPF3	0368
#define CadlincPF4	0369

#define CadlincNoScrl		0260
#define CadlincSetUp		0376
#define CadlincBreak		0340
#define CadlincUpArrow		0361
#define CadlincDownArrow	0362
#define CadlincLeftArrow	0363
#define CadlincRightArrow	0364

#define CadlincKPeriod	0262
#define CadlincKComma	0323
#define CadlincKMinus	0344
#define CadlincEnter	0303

#define CadlincK0	0261
#define CadlincK1	0300
#define CadlincK2	0301
#define CadlincK3	0302
#define CadlincK4	0320
#define CadlincK5	0321
#define CadlincK6	0322
#define CadlincK7	0341
#define CadlincK8	0342
#define CadlincK9	0343

#define wordchar(c) 	( (c >= '0' && c <= '9') || (c >= 'A' && c <= 'Z') || \
			  (c >= 'a' && c <= 'z') || (c == '_') )

#define	MinChar		'\0'
#define	MaxChar		'\377'

#define	MinPrintingChar	' '
#define	MaxPrintingChar '~'


/*
 * These are the unique identifiers for the standard keytables.  Client-defined
 * keytables with client-assigned identifiers may be added at runtime.  If the
 * client defines a keytable with one of these identifiers, the standard
 * keytable is redefined.
 */

#define	MainKeyTable		0	/* interpret char with no prefixes */
#define	SelectionKeyTable	1	/* interp char when selection exists */
#define	EscKeyTable		2	/* Escape prefix received */
#define	ANSIKeyTable		3	/* ANSI control prefix received */
#define PFKeyTable		4	/* SMI PF key prefix received */
#define	QuoteKeyTable		5	/* Next character quoted */
#define HiquoteKeyTable		6	/* Insert next char with high bit set */

#define	ClientKeyTable		7	/* Client's redefinitions; checked */ 
					/* first if present		   */

/*
 * These are the keytable opCode values that determine the operation to be
 * performed.
 */

#define KeyTableBeginRange	0	/* Start range of charCodes for an op */
#define KeyTableUseNext		1	/* Interp charCode in next keytable */
#define	KeyTableEnd		2	/* opCode to signal end of keytable */

#define	EditBackwardChar	3	/* move backward character */
#define	EditForwardChar		4	/* move forward character */
#define	EditBackwardWord	5	/* move backward word */
#define	EditForwardWord		6	/* move forward word */
#define	EditBeginLine		7	/* move to start of line */
#define	EditEndLine		8	/* move to end of line */
#define	EditUpLine		9	/* move up line */
#define	EditDownLine		10	/* move down line */
#define EditScrollUp		11	/* scroll screen up one row */
#define EditScrollDown		12	/* scroll screen down one row */
#define EditBackPage		13	/* Move screen back one page */
#define EditForwardPage		14	/* Move screen forward one page */
#define	EditBeginBuffer		15	/* move to start of line edit buffer */
#define	EditEndBuffer		16	/* move to end of line edit buffer */
#define	EditBeginInput		17	/* move to start of input */
#define	EditSelfInsert		18	/* Self insert character */
#define	EditSelfInsertHigh	19	/* Self-insert char with high bit set */
#define	EditDeleteChar		20	/* delete previous character */
#define	EditDeleteNextChar	21	/* delete next character */
#define	EditKillWord		22	/* kill previous word */
#define	EditKillNextWord	23	/* kill next word */
#define	EditKillLine		24	/* kill entire line */
#define	EditKillToEnd		25	/* kill to end of buffer */
#define	EditUnKill		26	/* Insert contents of killbuffer */
#define	EditTransposeChars	27	/* transpose previous two characters */
#define	EditTransposeWords	28	/* transpose previous two words */
#define	EditSetMark		29	/* set the Mark */
#define	EditSwapMarkCursor	30	/* Exchange the Mark and cursor */
#define	EditKillRegion		31	/* kill between mark and cursor */
#define	EditGrabSelection	32	/* Grab selection into killbuffer */
#define	EditExchangeSelection	33	/* exchange selection with killbuffer */
#define	EditKillSelection	34	/* kill current selection */
#define	EditDeselect		35	/* deselect current selection */
#define	EditInsertMode		36	/* Enter insert character mode */
#define EditOverwriteMode	37	/* Enter overwrite character mode */
#define	EditUppercaseWord	38	/* Convert word to uppercase */
#define	EditLowercaseWord	39	/* Convert word to lowercase */
#define	EditAbort		40	/* Ring bell and clear state */
#define	EditRedisplay		41	/* redisplay line edit buffer */
#define	EditRelease		42	/* Release the buffer; i.e. return */
#define EditReleaseAbort	43	/* Release buffer with ^G at end */
#define	EditEOF			44	/* Cause End-Of-File */
#define	EditKillBreak		45	/* Kill the break process */
#define	EditNop			46	/* No operation */
#define	EditDumpCursor		47	/* Dump cursor data */
#define	EditDumpCurrentChunk	48	/* Dump contents of current chunk */
#define	EditDumpMarklist	49	/* Dump contents of Marklist */
#define	EditDumpChunks		50	/* Dump all chunks in edit buffer */
#define	EditDumpFirstRows	51	/* Dump first six RowRecs */
#define	EditDumpLastRows	52	/* Dump last six RowRecs */
#define	EditDumpKillbuffer	53	/* Dump contents of Killbuffer */
#define	EditDumpMajorMarks	54	/* Dump major Marks */


/* standard interface to survive external world changes */
#define DisplaySend(p,c)		if (ebuf->displayed)PadPutChar(c,p)

#define DisplayClearToEOL(p)		if (ebuf->displayed)PadClearToEOL(p)  
#define DisplayCursorBackward(p)	if (ebuf->displayed)PadCursorBackward(p)
#define DisplayCursorForward(p) 	if (ebuf->displayed)PadCursorForward(p)
#define DisplayNewLine(p)		if (ebuf->displayed)PadNewLine(p)
#define DisplayPosition(p,l,c)		if (ebuf->displayed)PadPosition(p,l,c)
#define DisplayReturn(p)		if (ebuf->displayed)PadReturn(p)

#define Msg(s)		TtyPutString(s)
#define ErrorMsg(s)	TtyMessage(s)
#define	Beep		PadPutChar(BELL, pad)

/* new operations not in pad.c */

#ifndef DisplayInverse

#define DisplayInverse(p)	DisplayString(p,"\033[1m")
#define DisplayNormal(p)	DisplayString(p,"\033[0m")

#endif
