/*
 * V-System Pipe Server
 * CopyRight (c) 1981 David Cheriton, all rights reserved.
 * transliterated from Verex and Zed. May 1983.
 */

#include "pipe.h"
extern SystemCode ProcessRead();
extern SystemCode ProcessWrite();

SystemCode Write_pipe( req, pid, segsize )
    IoRequest *req; ProcessId pid; unsigned segsize;

    /* perform the "WRITE_INSTANCE" operation on a pipe. */
  {
    register PipeDesc *pipe;

    if( (pipe = Get_pipe(req->fileid) ) == NULL ) return( NOT_FOUND );

    /* check that this is a write end */
    if( (req->fileid & 1) != 0 ) return( NOT_WRITEABLE );

    if( req->bytecount > PIPE_BLOCK_SIZE ) return( BAD_BYTE_COUNT );

    /* check that the correct block is being written */
    /* Assume a duplicate message for last write operation if
     * same number and count as last block written. */
    if( (req->blocknumber == pipe->lastblock)
	  && req->bytecount == pipe->lastbytes )
	return( OK );

    if( req->blocknumber != pipe->lastblock + 1 ) return( BAD_BLOCK_NO );

    if( pipe->freebuffers == NULL )
      {
	if( pipe->writer != 0 ) /* Waiting writer already. */
	    if( ValidPid( pipe->writer ) ) return( RETRY );
	if( pipe->reader != 0 ) /* Waiting reader already. */
	  {
	    if( ValidPid( pipe->reader ) ) return( RETRY );
	    pipe->reader = 0;
	  }
	pipe->writer = pid;
	pipe->saveMsg = *(IoReply *)req;
	return( NO_REPLY );
      }
    return( ProcessWrite(pipe, req, pid, CurrentBuffer, segsize) );
  }

SystemCode ProcessWrite( pipe, req, pid, buffer, segsize )
	PipeDesc *pipe; IoRequest *req; ProcessId pid; Buffer *buffer;
	unsigned segsize;
  {
    register IoReply *reply = (IoReply *) req;
    register ProcessId reader;
    register Buffer *buf;
    register SystemCode r;

    /* Zero the writer field */
    pipe->writer = 0;
    /* Get data in buffer. */
    if( req->bytecount <= IO_MSG_BUFFER )
	if (DifferentByteOrder(pid))
	    ByteSwapLongCopy(req->shortbuffer, buffer->data,
			     (req->bytecount+3)&~3);
	else
	    Copy(buffer->data, req->shortbuffer, req->bytecount);
    else if( req->bytecount > segsize )
      {
	if( (r=MoveFrom(pid,buffer->data,req->bufferptr,req->bytecount)) != OK )
	    return( r );
      }
    buffer->count = req->bytecount;

    pipe->lastblock++;
    pipe->lastbytes = req->bytecount;

    /* Discard data if no read end */
    if( pipe->readowner == 0 ) return( OK );

    if( buffer == CurrentBuffer ) /* Trade current buffer with a pipe free buffer. */
      {
	CurrentBuffer = pipe->freebuffers;
	pipe->freebuffers = pipe->freebuffers->next;
      }
    else /* Assume it is first on free list */
	pipe->freebuffers = buffer->next;

    /* Queue the buffer. */
    buffer->next = NULL;
    if( (buf = pipe->lastbuffer) == NULL )
	pipe->nextbuffer = buffer;
    else
	buf->next = buffer;
    pipe->lastbuffer = buffer;
    pipe->lastbytes = buffer->count;

    if( reader = pipe->reader )
      {
	buf = pipe->nextbuffer;
	r = ProcessRead( pipe, &pipe->saveMsg, reader, buf );
	reply->replycode = r;
	Reply( reply, reader );
      }
    return( OK );
  }
