/*
 * V-System Pipe Server
 * CopyRight (c) 1981 David Cheriton, all rights reserved.
 * transliterated from Verex and Zed. May 1983.
 */

#include "pipe.h"

PipeServer()

    /* Base function executed by the pipe server process. */
  {
    register ProcessId  pid;
    SystemCode  reply;
    Message	msg;
    register IoRequest *req = (IoRequest *) msg;
    register IoReply *replymsg = (IoReply *) msg;
    unsigned segsize;

    Initialize();
    while(1)
      {
	segsize = PIPE_BLOCK_SIZE;
        pid = ReceiveWithSegment( req, CurrentBuffer->data, &segsize );

        switch( req->requestcode )
          {
            case CREATE_INSTANCE:
                reply = Create_pipe( req, pid );
		break;
            case QUERY_INSTANCE:
                reply = Query_pipe( req, pid );
		break;
            case SET_INSTANCE_OWNER:
                reply = Set_pipe_owner( req, pid );
		break;
            case RELEASE_INSTANCE:
                reply = Release_pipe( req, pid );
		break;
            case READ_INSTANCE:
                reply = Read_pipe( req, pid );
		break;
            case WRITE_INSTANCE:
	    case WRITESHORT_INSTANCE:
                reply = Write_pipe( req, pid, segsize );
		break;
            case RECLAIM:
                reply = Reclaim_pipe();
		break;
            default: /* unrecognized request */
                reply = ILLEGAL_REQUEST;
          }
        if( reply == NO_REPLY ) continue;
        replymsg->replycode = reply;
        Reply( req, pid );
      }
  }

Initialize()

    /* initialize pipe server */
  {
    register unsigned i;

    /* announce the pipe server to the kernel name server. */
    Me = GetPid( ACTIVE_PROCESS, LOCAL_PID );
    SetPid( PIPE_SERVER, Me, ANY_PID );
    CurrentBuffer = (Buffer *) malloc( sizeof(Buffer) );
    for( i=0; i<(PIPE_MASK+1); i++ ) Pipe_table[i] = NULL;
  }
