/*
 * V-System Pipe Server
 * CopyRight (c) 1981 David Cheriton, all rights reserved.
 * transliterated from Verex and Zed. May 1983.
 */

#include "pipe.h"

extern SystemCode ProcessRead();
extern SystemCode ProcessWrite();

long secs; int clicks;

SystemCode Read_pipe( req, pid )
   IoRequest *req; ProcessId pid;

    /* perform the "READ_INSTANCE" operation on a pipe. */
  {
    register Buffer *buffer;
    register IoReply *reply = (IoReply *) req;
    register PipeDesc  *pipe;

    if( (pipe = Get_pipe(req->fileid)) == NULL ) return( NOT_FOUND );

    /* ensure that this is the read end of a pipe. */
    if( ((req->fileid) & 1 ) == 0 ) return( NOT_READABLE );

    if( req->bytecount > PIPE_BLOCK_SIZE ) return( BAD_BYTE_COUNT );

    /* Handle a duplicate or retransmitted read operation. */
    if( (req->blocknumber == pipe->nextblock-1) && pipe->lastbufferread != NULL )
      {
	buffer = pipe->lastbufferread;
	pipe->lastbufferread = NULL;
	ProcessRead( pipe, req, pid, buffer );
	return( NO_REPLY );
      }
    if( pipe->reader )
      {
	if( ValidPid( pipe->reader ) ) return( RETRY );
 	pipe->reader = 0;
      }
    if( req->blocknumber != pipe->nextblock ) return( BAD_BLOCK_NO );

    if( (buffer = pipe->nextbuffer) == NULL )
      { /* No data buffers available. */
	if( pipe->writeowner == 0 )
	  {
	    reply->bytecount = 0;
	    return( END_OF_FILE );
	  }
	if( pipe->writer )
	  {
	    if( ValidPid( pipe->writer ) ) return( RETRY );
	    pipe->writer = 0;
	  }
	pipe->reader = pid;
	pipe->saveMsg = *reply;
	return( NO_REPLY );
      }

    return( ProcessRead( pipe, req, pid, buffer) );
  }

SystemCode ProcessRead( pipe, req, pid, buffer )
	PipeDesc *pipe; IoRequest *req; ProcessId pid; Buffer *buffer;
  {
    register IoReply *reply = (IoReply *) req;
    register ProcessId writer;
    register Buffer *buf;
    register SystemCode r;

    /* Zero the reader field */
    pipe->reader = 0;
    
    if( (buf=pipe->lastbufferread) != NULL )
      {
	/* Free last buffer read. */
	buf->next = pipe->freebuffers;
	pipe->freebuffers = buf;
      }
    pipe->lastbufferread = buffer;
    if( pipe->nextbuffer == buffer ) /* If in the queue of buffers, remove */
	if( (pipe->nextbuffer = buffer->next) == NULL )
		pipe->lastbuffer = NULL;
	

    if( buffer->count < req->bytecount ) reply->bytecount = buffer->count;
    reply->replycode = OK;
    if( reply->bytecount <= IO_MSG_BUFFER )
      {
	if (DifferentByteOrder(pid))
	    ByteSwapLongCopy(buffer->data, reply->shortbuffer, 
			     (reply->bytecount+3)&~3);
	else
	    Copy(reply->shortbuffer, buffer->data, reply->bytecount);
	reply->replycode = OK;
	Reply( reply, pid );
      }
    else
	ReplyWithSegment(reply,pid,buffer->data,req->bufferptr,reply->bytecount);

    pipe->nextblock++;

    if( (writer=pipe->writer) && (buf=pipe->freebuffers) != NULL )
      {
	r = ProcessWrite( pipe, &pipe->saveMsg, writer, buf, 0 );
	reply->replycode = r;
	Reply( reply, writer );
      }
    return( OK );
  }
