/*
 * V-System Pipe Server
 * CopyRight (c) 1981 David Cheriton, all rights reserved.
 * transliterated from Verex and Zed. May 1983.
 */

#include "pipe.h"

PipeDesc *Alloc_pipe()

    /* Allocate a pipe end descriptor and mark as to new id. */
  {
    register    PipeDesc *pipe;
    unsigned    i;

    /* Find a non-zero unused pipe end identifier. */
    while( ++Pipe_generator == 0 || Get_pipe(Pipe_generator<<1) != NULL );

    pipe = (PipeDesc *) calloc( 1, sizeof(PipeDesc) );

    i = Pipe_generator;
    pipe->pipeid = i << 1;
    pipe->link = Pipe_table[i&PIPE_MASK];
    Pipe_table[i&PIPE_MASK] = pipe;

    return( pipe );
  }


PipeDesc *Get_pipe( id )
   InstanceId id;

    /* Return a pointer to the file instance descriptor specified
     * by id if it exists.
     */
  {
    register PipeDesc *pipe;
    register InstanceId evenid;

    evenid = id & ~1;
    pipe = Pipe_table[(id>>1)&PIPE_MASK]; /*  Hash to table location. */

    while( (pipe != NULL) && (pipe->pipeid != evenid) ) pipe = pipe->link;
    if( pipe == NULL ) return( NULL );
    if( (id & 1) && (pipe->readowner == 0) ) return( NULL );
    if( ((id & 1) == 0) && (pipe->writeowner == 0) ) return( NULL );

    return( pipe );
  }

Delete_pipe( pipe )
    PipeDesc *pipe;

    /* delete a pipe, freeing its storage and destroying its pipe file.
     * Actually, release the end whose owner has gone away, discarding
     * the pipe totally if both owners are gone.
     */
  {
    Message      msg;
    register IoReply *reply = (IoReply *) msg;
    register ProcessId writer;
    register PipeDesc  *ptr;
    register Buffer *buffer;
    register unsigned endsopen;

    endsopen = 2;
    if( pipe->writeowner == 0 )
      {
	endsopen--;
	if( pipe->writer )
	  {
	    reply->replycode = END_OF_FILE;
	    reply->bytecount = 0;
	    Reply( reply, pipe->writer );
	    pipe->writer = 0;
	  }
	if( pipe->reader )
	  {
	    reply->replycode = END_OF_FILE;
	    reply->bytecount = 0;
	    Reply( reply, pipe->reader );
	    pipe->reader = 0;
	  }
      }	

    if( pipe->readowner == 0 )
      {
	endsopen--;
	if( pipe->reader )
	  {
	    reply->replycode = END_OF_FILE;
	    reply->bytecount = 0;
	    Reply( reply, pipe->reader );
	    pipe->reader = 0;
	  }
	if( pipe->writer )
	  {
	    pipe->saveMsg.replycode = OK;
	    Reply( &pipe->saveMsg, pipe->writer );
	    pipe->writer = 0;
	  }
	if( pipe->lastbufferread ) free( pipe->lastbufferread );
	while( (buffer = pipe->nextbuffer) != NULL )
	  {
	    pipe->nextbuffer = buffer->next;
	    free( buffer );
	  }
	while( (buffer = pipe->freebuffers) != NULL )
	  {
	    pipe->freebuffers = buffer->next;
	    free( buffer );
	  }
      }
    if( endsopen == 0 ) /* Free descriptor for pipe. */
      {
	ptr = (PipeDesc *) &(Pipe_table[((pipe->pipeid)>>1) & PIPE_MASK]);
        while( ptr->link != pipe ) ptr = ptr->link;
	ptr->link = pipe->link;
        free( pipe );
	if( --Pipes == 0 ) 
	    DestroyProcess( Reminder_process );
      }	  
  }
