/*
 * readfile.c
 *
 * Read a file into memory.
 *
 */

#include <Vio.h>

ReadBootfile(filename, buffer)
    char *buffer, *filename;
  /*
   * This routine reads a file into the buffer pointed to by "buffer."
   *  If errors occur during loading, a message is printed 
   *  and exit() is called to abort the program.
   */

  {
    File *f;
    SystemCode error;
    int count;

    f = Open(filename, FREAD, &error);
    if (error != OK)
      {
	fprintf(stderr, "Error opening bootfile %s: %s\n", filename,
		ErrorString(error));
	exit(1);
      }

    do
      {
        count = Read(f, buffer, BlockSize(f));
	buffer += count;
	f->block++;
      }
    while (f->lastexception == OK);

    if (f->lastexception != END_OF_FILE)
      {
	fprintf(stderr, "Error reading bootfile %s: %s\n", filename,
		ErrorString(f->lastexception));
	exit(1);
      }
  }
