/*
 * readfile.c
 *
 * Yet another loadfile() descendant.  This one uses the Sun boot
 *   protocol (EFTP-based) to read a file into a Sun, but does not
 *   assume the file contains a program.  This is a throwback since
 *   the now-lost predecessor of loadfile() also did this.
 *
 */

#include <eftp.h>
#include <pupstatus.h>
#include <pupconstants.h>
#include <puproute.h>
#define MAXPERCALL 1024	/* Buffer size used for receiving */
#define MAX_NAME_LENGTH 128 /* Maximum file name length */

#define TYMEOUT 20 /* seconds (?) */
#define RETRIES 5 /* counts initial try */

#define TRUE 1
#define FALSE 0
#define NUL '\0'
#define error(string) {printf("%s\r\n%s\r\n",string,PupErrMsg); exit(); }

ReadBootfile(filename, buffer)
    char *buffer, *filename;

  /*
   * This routine reads a file from a boot server, into the buffer pointed
   *  to by "buffer."  If errors occur during loading, a message is printed 
   *  and exit() is called to abort the program.
   */

  {
    struct EftpChan loadchan;	/* EFTP channel used for loading */
    struct Port serverport;		/* Server's port (address) */
    int totalsize, rsize, retcode, host, i, retry, socket;
    char *loadptr, *symptr, *p;
    char newfilename[2*MAX_NAME_LENGTH+1];

    /* Parse filename.  If it starts with a '[', take the string
     *   inside the brackets as a host identifier */

    if (*filename == '[')
      {
	p = ++filename;		/* Point to start of host name */
	while (*p != ']' && *p != NUL) p++;
	*p = NUL;  		/* Terminate string at colon */
	retcode = mlookup(filename, &serverport);
	if (retcode != OK) error("?Can't identify host.");
	filename = ++p;  /* Point to rest of filename */
      }
    else
      {
	/* If no host given, broadcast to the net we're on */
	InitRoutingTable(RoutingTable, &ConnectedNets);
		/* ^ kludge courtesy of Jeff Mogul */
	serverport.net = 0;
	serverport.host = 0;
      }

    serverport.socket = MISCSERVICES;

    /* Pick a random socket */
    socket = K_ticks();
    if (socket <= MAXWELLKNOWNSOCKET) socket += MAXWELLKNOWNSOCKET;

    /* Open Eftp channel */
    if (EfRecOpenS(&loadchan, &serverport, TYMEOUT, 0, socket) != OK)
	error("?Can't open EFTP channel.");

    loadptr = buffer;
    retry = RETRIES;
    do
      {    
        /* Send out boot request */
        if (msunbootreq(&serverport, socket, 0, filename) != OK)
	    error("?Can't send boot request.");

        /* Read first block of file */
        retcode = EftpRead(&loadchan,loadptr,MAXPERCALL,&rsize);
	loadptr += rsize;

        if (retcode == OK)
	    putchar('!');
	else
	    putchar('.');
      }
    while (retcode == TIMEOUT && --retry);

    if (retcode == TIMEOUT) error("?Timeout.");
    if (retcode != OK && retcode != EFTP_ENDOFFILE)
	error("?Can't load file--EFTP failed.");

    /* Receive rest of file */
    totalsize = rsize;
    while (retcode != EFTP_ENDOFFILE)
      {
	retcode = EftpRead(&loadchan,loadptr,MAXPERCALL,&rsize);
	putchar('!');
	totalsize += rsize;
	loadptr += rsize;
	if (retcode == TIMEOUT) error("?Timeout.");
	if (retcode != OK && retcode != EFTP_ENDOFFILE)
	    error("?Can't load file--error during EFTP.");
      }

    /* File all loaded. */
    puts("\r\n");

  }

