/*
 * Interface to the lookup and cache routines for config files, tailored for
 * bootstrap file-servers.  Interface could do with some refining.
 */

/* 
 * Include the following.  All this rubbish just to get time_t and struct
 *   ether_addr.  Is it really worth it?
 * #include <sys/types.h>
 * #include <sys/stat.h>
 * #include <sys/socket.h>
 * #include <net/if.h>
 * #include <netinet/in.h>
 * #include <netinet/if_ether.h>
 */

/*
 * These two strings are only used by the implementation, but we declare them
 *   here just so you know what magic is going on inside the implementation.
 */
# define BootProperty "boot:"		   /* yes or no (if no, don't boot) */
# define Bootfile "bootfile:"		   /* Absolute pathname of boot file*/

struct HostTableEntry
  {
  	/*
	 * Table entry to recall whom we are allowed to boot.
	 * Note that addresses are stored in big-endian byte order
	 */
    char *path;			/* Path to the config file */
    char *bootpath;		/* Path to the boot file   */
    time_t mtime;		/* Config file modification time */
    struct ether_addr ether;	/* Ether address */
  };

struct HostTableEntry *ReadConfigFileByAddress(), *ReadConfigFileWithAwk(),
		      *HostLookup(), *UseDefaults();
/* Caveat: UseDefaults() recycles the same HostTableEntry on each invocation */

/*
 * Flags used by the configboot routines: 0 = false, 1 = true
 */
extern int ccDebug,	/* Print debug info. 		 Initalized to 0  */
	   ccVerbose,	/* Print general info. 		 Initialized to 0  */
	   ccCheckTimes;/* Check file modification times when using cached */
			/* data; re-cache if necessary.  Initialized to 1  */

extern char *ccDefaultProgram;	/* Program (boot file) to load if none other */
				/*   specified.  Initialized to 0	     */
extern char *ccConfigDir;	/* Where to look for config files.  This is  */
				/* given a default value by configboot.c.    */
