/*			Memory File Server
 *
 * Global type and constant definitions
 */

#include <Venviron.h>
#include <Vnaming.h>
#include <Vdirectory.h>

#define IsLocal(pid) ( (((pid) ^ mypid) & LOGICAL_HOST_PART) == 0 )

typedef unsigned char mem;

typedef struct _fd
  {
    char	 name[MAX_NAME_LENGTH];
    mem		*start;
    long	 size;
    short	 nblocks;
    long	 timestamp;
    struct _fd	*father;
    struct _fd	*brother;
    struct _fd	*son;
    ContextPair	 ctxpair;
  }
Filedesc;

#define MS_ALIAS -1	/* size == -1 flags an alias for fd->son */

typedef struct _inst
  {
    Filedesc 	*fd;
    ProcessId 	owner;
    short	type;
    short	kind;
  }
Instance;

#define MAX_INSTANCES 16
#define BLOCKSIZE 1024
#define CLEARING  16	/* number of blocks added when a file needs to grow */

#define FAKE_PERMISSIONS  0x739c  /* rwe--rwe--rwe-- */

#define TRUE 1
#define FALSE 0

#define GROW_FILE           0x2001   /* idempotent */
#define CHANGE_FILE_SIZE    0x0002

/* instance kinds */
#define FILE_INSTANCE 1
#define DIRECTORY_INSTANCE 2

extern Filedesc *fdtable, *fdfile, *stringfile;
extern Instance insttable[];
extern ProcessId mypid;
extern unsigned memtop, memlimit, nfiles, debug, maxmem, keepmem;

/* divide by BLOCKSIZE, rounding up not down */
#define CountBlocks(bytes)  (bytes/BLOCKSIZE + \
				((bytes & (BLOCKSIZE-1)) ? 1 : 0) )

extern mem *AddBlocks(), *RequireBlocks();
extern char *StoreString();
extern SystemCode LookupFile(), NewFile();
extern Instance *GetInstance(), *AllocInstance(), *FindInstance();
extern Filedesc *GetFreeFd();
