/*			Memory File Server
 *
 * Handling of directory-related requests
 */

#include <Vioprotocol.h>
#include <Vdirectory.h>
#include <Vstorage.h>
#include <Vgroupids.h>
#include "memserv.h"

extern SystemCode HandleQueryInstance(), LookupFile();

static ArbitraryDescriptor descbuffer;

SystemCode CreateDirectoryInstance(req, pid, segbuf, segsize)
  register CreateInstanceRequest *req;
  ProcessId pid;
  char *segbuf;
  unsigned segsize;
  {
    register Instance *instance;
    IoReply	*replymsg = (IoReply *) req;
    Filedesc *fd;
    SystemCode err;

    err = LookupFile(req, pid, &fd, NULL, segbuf, segsize);
    if (err != OK) return err;
    
    if( (instance=AllocInstance(pid)) == NULL )
        return( NO_SERVER_RESOURCES );

    instance->owner = pid;
    instance->fd = fd;
    instance->type = READABLE|FIXED_LENGTH;
    instance->kind = DIRECTORY_INSTANCE;

    replymsg->fileid = instance - insttable; /* id = index in instance table */
    err = HandleQueryInstance(replymsg);

    if (err == OK && IsGroupId(fd->ctxpair.pid) && IsGroupId(Forwarder(pid)))
	return MORE_REPLIES;
    else
    	return err;
  }


ConstructDescriptor(desc, fd, pid)
  register ArbitraryDescriptor *desc;
  register Filedesc *fd;
  ProcessId pid;
  {
    register Filedesc *fd2;

    /* Construct a descriptor */
    if (fd->size == MS_ALIAS)
        fd2 = fd->son;
    else
	fd2 = fd;

    if (IsGroupId(fd->ctxpair.pid))
      {
        desc->c.descriptortype = CONTEXT_DESCRIPTOR;
        strncpy(desc->c.name, fd->name, MAX_NAME_LENGTH);
	desc->c.ctxpair = fd2->ctxpair;
	if (DifferentByteOrder(pid)) ByteSwapContextDescriptor(&(desc->c));
      }
    else
      {
	desc->f.descriptortype = FILE_DESCRIPTOR;
        strncpy(desc->f.name, fd->name, MAX_NAME_LENGTH);
	desc->f.timestamp = fd2->timestamp;
	desc->f.perms = FAKE_PERMISSIONS + (fd2->son != NULL ? SS_DIR : 0);
	desc->f.size = fd2->size;
	if (DifferentByteOrder(pid)) ByteSwapFileDescriptor(&(desc->f));
      }
  }

SystemCode ReadDirectory(req, id)
  register IoRequest *req;
  ProcessId id;
  {
    register ArbitraryDescriptor *desc = &descbuffer;
    register Filedesc *fd;
    register Instance *instance;
    register unsigned bytecount;
    register IoReply *reply = (IoReply *) req;
    register int i;

    if ((instance = GetInstance(req->fileid)) == NULL)
	return INVALID_FILE_ID;
    if (instance->kind != DIRECTORY_INSTANCE)
	Fatal("ReadDirectory improperly called");
    
    bytecount = req->bytecount;
    reply->bytecount = 0;
    if (bytecount > sizeof(ArbitraryDescriptor)) return BAD_BYTE_COUNT;

    /* Find the nth child of instance->fd */
    fd = instance->fd->son;
    for (i = 0; i < req->blocknumber; i++)
      {
	if (fd == NULL) break;
	fd = fd->brother;
      }
    if (fd == NULL) return END_OF_FILE;

    if (fd->size == MS_ALIAS && !IsLocal(id))
      {
	/* Aliases are only recognized for local requestors */
	desc->e.descriptortype = EMPTY_DESCRIPTOR;
	if (DifferentByteOrder(id)) ByteSwapEmptyDescriptor(&(desc->e));
      }
    else
      {
	ConstructDescriptor(desc, fd, id);
      }

    if (fd->brother == NULL)
        reply->replycode = END_OF_FILE;
    else
        reply->replycode = OK;

    reply->bytecount = bytecount;
    ReplyWithSegment(reply, id, desc, req->bufferptr, bytecount);

    return NO_REPLY;
  }


SystemCode HandleNreadDescriptor(req, id, segbuf, segsize)
  DescriptorRequest  *req;
  ProcessId id;
  char *segbuf;
  unsigned segsize;
  {
    register DescriptorReply  *reply = (DescriptorReply *) req;
    register ArbitraryDescriptor   *desc = &descbuffer;
    Filedesc	*fd;
    SystemCode  r;


    if( (r = LookupFile(req, id, &fd, NULL, segbuf, segsize)) != OK )
      return( r );

    ConstructDescriptor(desc, fd, id);
      
    reply->replycode = OK;
    reply->segmentptr = req->segmentptr + req->dataindex;
    reply->segmentlen = sizeof(ArbitraryDescriptor);
    ReplyWithSegment(reply, id, desc, req->segmentptr, 
    	sizeof(ArbitraryDescriptor));
    return NO_REPLY;
  }


SystemCode HandleReadDescriptor(req, id)
  DescriptorRequest  *req;
  ProcessId id;
  {
    register DescriptorReply	 *reply = (DescriptorReply *) req;
    register ArbitraryDescriptor *desc = &descbuffer;
    register Instance		 *instance;
    register Filedesc		 *fd;

    if( (instance = GetInstance(req->fileid)) == NULL )
      return( INVALID_FILE_ID );

    fd = instance->fd;

    ConstructDescriptor(desc, fd, id);

    reply->replycode = OK;
    reply->segmentlen = sizeof(ArbitraryDescriptor);
    ReplyWithSegment(reply, id, desc, req->segmentptr, 
    	sizeof(ArbitraryDescriptor));
    return NO_REPLY;
  }
  

