/************************************************************************/
/*		   (C) COPYRIGHT 1983,1984,1985,1986			*/
/*                         BOARD OF TRUSTEES				*/
/*                 LELAND STANFORD JUNIOR UNIVERSITY			*/
/*                    STANFORD, CA. 94305, U.S.A.			*/
/************************************************************************/

/*
 * Routines related to byte swapping.
 */

#include "net.h"
#include "internet.h"
#include "arp.h"

/* Swap the bytes of a short word in place */

ByteSwapShortInPlace(p)
    register char *p;
  {
    char t;

    t = p[0];
    p[0] = p[1];
    p[1] = t;
  }


/* The following are needed only if running on a little-endian machine */

#ifdef  LITTLE_ENDIAN
SwapARP(p)
    register ArpPktPtr p;
{
    ByteSwapShortInPlace((char *)&p->hrd);
    ByteSwapShortInPlace((char *)&p->pro);
    ByteSwapShortInPlace((char *)&p->op);
    SwapEnet10Adr(&p->sha);
    ByteSwapLongInPlace((char *)&p->spa[0], 4);
    SwapEnet10Adr(&p->tha);
    ByteSwapLongInPlace((char *)&p->tpa, 4);
}


SwapIP(p)
  IpHdrPtr p;
{
    ByteSwapShortInPlace((char *)&p->tl);
    ByteSwapShortInPlace((char *)&p->id);
    ByteSwapShortInPlace((char *)&p->flags_fo);
    ByteSwapShortInPlace((char *)&p->checksum);
    ByteSwapLongInPlace((char *)&p->srcAdr, 4);
    ByteSwapLongInPlace((char *)&p->dstAdr, 4);
}


SwapTCP(p)
  struct TcpHeader *p;
{
    ByteSwapShortInPlace((char *)&p->sourcePort);
    ByteSwapShortInPlace((char *)&p->destinationPort);
    ByteSwapLongInPlace((char *)&p->sequenceNumber, 4);
    ByteSwapLongInPlace((char *)&p->acknowledgementNumber, 4);
    ByteSwapShortInPlace((char *)&p->acknowledgementNumber +
	sizeof p->acknowledgementNumber);
    ByteSwapShortInPlace((char *)&p->window);
    ByteSwapShortInPlace((char *)&p->checkSum);
    ByteSwapShortInPlace((char *)&p->urgentPointer);
};


SwapICMP(p)
    struct IcmpCommonHeader *p;
  {
    ByteSwapShortInPlace((char *)&p->type);
    ByteSwapShortInPlace((char *)&p->type);
  }


SwapEnet10Adr(p)
  Enet10Address *p;
{
    ByteSwapShortInPlace((char *)&p->addrhigh);
    ByteSwapShortInPlace((char *)&p->addrmid);
    ByteSwapShortInPlace((char *)&p->addrlow);
}
#endif  LITTLE_ENDIAN
