/************************************************************************/
/*		        (C) COPYRIGHT 1985,1986				*/
/*                         BOARD OF TRUSTEES				*/
/*                 LELAND STANFORD JUNIOR UNIVERSITY			*/
/*                    STANFORD, CA. 94305, U.S.A.			*/
/************************************************************************/

/*
 * Internetserver statistics collection routines.
 *
 * Created: 13-Feb-86				Author: Bruce L Hitson
 */

#include "net.h"
#include "internet.h"
#include <Vgroupids.h>
#include "stats.h"

ProcessId statsGid = 0;		/* Group id of statistics processes */
Boolean StatsEnabled = False;	/* Report per-connection statistics */

int StatsSendInterval = C_StatsSendInterval;
				/* Interval at which periodic statistics
				   messages are sent (multiple of the clicks
				   rate specified by CleanupTimer) */
int StatsSendCounter = 0;
				/* Counts StatsSendInterval */
int StatsEnableCounter = C_StatsEnableInterval;
				/* Counts StatsEnableInterval */


/*
 * Externals
 */

extern int StatsStartTime;
extern int StatsUser;
extern int FreeBufferCount;
extern int TotalBufferCount;
extern SpinLockType InstanceLock;
extern SpinLockType BufferLock;
extern SpinLockType PrintfLock;
extern int AllocBusyWait;
extern int NumAllocCalls;
extern int EnetReadCount;
extern int EnetWriteCount;


/*
 * HandleStatsRequest:
 * Process a statistics request.  This is typically the periodic "keep
 * alive" traffic sent by active stats servers (StatsPeriodicEnable).
 */

SystemCode HandleStatsRequest(rqMsg, pid)
    InternetStatsRequest *rqMsg;
    ProcessId pid;
  {
    SystemCode reply = DISCARD_REPLY;	/* Default response to datagram send */

    switch(rqMsg->opcode)
      {
	case StatsPeriodicEnable:	/* Enable per-connection stats */
	  {
	    if (statsGid != rqMsg->pid)
	      {
		if (statsGid == 0)	/* Initial discovery of group */
		  {
		    statsGid = rqMsg->pid;
		    if (InternetDebug)
		      {
			printf("Discovered statsGid=0x%x from pid=0x%x\n",
			    statsGid,pid);
		      }
		  }
		else
		  {
		    if (rqMsg->pid != 0)/* Multiple groups?  Complain! */
		      {
			if (InternetDebug)
			  {
			    printf("Multiple stats groups? ");
			    printf("old:0x%x, new:0x%x\n",statsGid,rqMsg->pid);
			    if (rqMsg->pid > statsGid)
			      {
				statsGid = rqMsg->pid;
			        printf("Switching to new statsGid=0x%x\n",
				    statsGid);
			      }
			  }
		      }
		    else if (InternetDebug) 
			printf("Ignoring StatsPeriodicEnable with pid=0!\n");
		    break;
		  }
	      }
	    else if (statsGid == 0 && InternetDebug)
	      {
		printf("Ignoring StatsPeriodicEnable with pid=0!\n");
		break;
	      }
	    if (InternetDebug > 3) 
		printf("Pid 0x%x enabling stats timer with statsGid=0x%x\n",
		    pid,rqMsg->pid);
	    StatsEnabled = True;
	    StatsEnableCounter = C_StatsEnableInterval;
	    break;
	  }

	case StatsGlobalInquiry:	/* Server wide statistics */
	  {
	    if (InternetDebug)
	        printf("StatsRequest: responding to 'GlobalInquiry'\n");
	    SendGlobalStats();
	    break;
	  }

	case StatsTellMeStatsGroup:	/* New stats server on the prowl */
	  {
	    if (InternetDebug)
	        printf("Stats server pid 0x%x is looking for action\n",pid);
	    break;
	  }

	default:
	  {
	    if (InternetDebug)
	        printf("Unknown statistics request ->%d<-\n", rqMsg->opcode);
	    break;
	  }
      }
    return(reply);
  }


/*
 * SendGlobalStats:
 * Send information about global internetserver statistics to the
 * INTERNET_STATISTICS_GROUP
 */

SendGlobalStats()
  {
    GlobalStatsMsg m;
    Message msg;
    InternetStatsRequest *rqMsg = (InternetStatsRequest *) msg;
    QueryEnetReply *rpMsg = (QueryEnetReply *) msg;
    int i;

    if (statsGid == 0)
      {
	if (InternetDebug)
	    printf("Can't send GLOBAL stats - don't know statsGid!\n");
	StatsEnabled = False;
	return;
      }

    m[ 0] = GlobalStatsMsgCode;			/* Msg type */
    m[ 1] = 1;					/* Version id */
    m[ 2] = 0;					/* Unused */
    m[ 3] = 0;					/* Unused */
    m[ 4] = StatsStartTime;			/* When we started */
    m[ 5] = GetTime(0);				/* Time now */
    m[ 6] = StatsUser;				/* User owning server */
    m[ 7] = LocalIpHost;			/* Local address */
    m[ 8] = FreeBufferCount;			/* Buffers free */
    m[ 9] = TotalBufferCount;			/* Buffers in pool */
    m[10] = SpinLockCount(InstanceLock);	/* Instance contention */
    m[11] = SpinLockCount(BufferLock);		/* Buffer contenetion */
    m[12] = SpinLockCount(PrintfLock);		/* Printf contention */
    m[13] = AllocBusyWait;			/* Busy wait contention */
    m[14] = NumAllocCalls;			/* Buffer allocations */

    QueryPnet(rpMsg);

    if (rpMsg->replycode == OK)
      {
	m[15] = rpMsg->NumValidPackets;		/* Enet valid packets */
	m[16] = rpMsg->NumCollisions;		/* Enet collisions */
	m[17] = rpMsg->NumOverflows;		/* Enet overflows */
	m[18] = rpMsg->NumCRCErrors;		/* Enet crc errors */
	m[19] = rpMsg->NumSyncErrors;		/* Enet sync errors */
	m[20] = rpMsg->NumTimeOuts;		/* Enet timeouts */
      }
    else for (i=15; i<=20; i++) m[i] = 0;

    m[21] = EnetReadCount;			/* # enet reads */
    m[22] = EnetWriteCount;			/* # enet writes */

    if (InternetDebug) printf("SendGlobalStats: sending statistics msg...");

    rqMsg->requestcode = StatsMessage | DATAGRAM_SEND_BIT;
    rqMsg->opcode = StatsOnInternetServer;
    rqMsg->bufferptr = (char *) &m[0];
    rqMsg->bytecount = 92;		/* 23*4 bytes */
    Send(msg, statsGid);		/* Datagram send! */
    if (InternetDebug) printf("done\n");
    return;
  }



/*
 * SendTcpStats:
 * Send information about a TCP connection that is closing.
 */

SendTcpStats(pTcb)
    TcpTcbPtr pTcb;
  {
    TcpStatsMsg m;
    Message msg;
    InternetStatsRequest *rqMsg = (InternetStatsRequest *) msg;

    if (statsGid == 0)
      {
	if (InternetDebug)
	    printf("Can't send TCP stats - don't know statsGid!\n");
	StatsEnabled = False;
	return;
      }

    m[ 0] = TcpStatsMsgCode;		/* Msg type */
    m[ 1] = 1;				/* Version id */
    m[ 2] = 0;				/* Unused */
    m[ 3] = 0;				/* Unused */
    m[ 4] = pTcb->creationTime;		/* Secs at connection creation */
    m[ 5] = GetTime(0);			/* Secs at connection close */
    m[ 6] = pTcb->user;			/* User number of creator process */
    m[ 7] = LocalIpHost;		/* Ip Addr of internetserver */
    m[ 8] = LocalIpHost;		/* Ip Addr of source host */
    m[ 9] = pTcb->localPort;		/* Tcp port of source */
    m[10] = pTcb->foreignSocket.host;	/* Ip Addr of destination */
    m[11] = pTcb->foreignSocket.port;   /* Tcp port of destination */
    m[12] = pTcb->segmentsSent;		/* Total segments sent */
    m[13] = pTcb->bytesSent;		/* Total bytes sent */
    m[14] = pTcb->numRetransTimeouts;	/* Total retransmissions */
    m[15] = pTcb->totAckTime;		/* Total accum ack time (clicks) */
    m[16] = pTcb->segmentsRcvd;		/* Total segments rcvd */
    m[17] = pTcb->bytesRcvd;		/* Total bytes rcvd */
    m[18] = pTcb->numOutOfOrderPkts;	/* Total out of order pkts */

    if (InternetDebug) printf("SendTcpStats: sending statistics msg...");

    rqMsg->requestcode = StatsMessage | DATAGRAM_SEND_BIT;
    rqMsg->opcode = StatsOnTcpConnection;
    rqMsg->bufferptr = (char *) &m[0];
    rqMsg->bytecount = 76;		/* 19*4 bytes */
    Send(msg, statsGid);		/* Datagram send! */
    if (InternetDebug) printf("done\n");
    return;
  }
