/************************************************************************/
/*		   (C) COPYRIGHT 1983,1984,1985,1986			*/
/*                         BOARD OF TRUSTEES				*/
/*                 LELAND STANFORD JUNIOR UNIVERSITY			*/
/*                    STANFORD, CA. 94305, U.S.A.			*/
/************************************************************************/

/*
 * Definition file for multi-protocol tables.
 */


#include "net.h"


/* Connection protocols */

extern int InitIp();
extern SystemCode CreateIpConnection();
extern SystemCode NQueryIpFile();
extern int NextIpTimeout();
extern int InitTcp();
extern SystemCode CreateTcpConnection();
extern SystemCode NQueryTcpFile();
extern int NextTcpTimeout();
extern int InitIcmp();
extern SystemCode CreateIcmpConnection();
extern SystemCode NQueryIcmpFile();
extern int NextIcmpTimeout();

/* Network level protocols */

extern int InitNetIp();
extern int RcvAllIp();
extern int InitNetArp();
extern int RcvAllArp();


struct FuncBlock FuncTable[NumProtocols] =
				/* Function table definition */
  {
    {
      InitIp,
      CreateIpConnection,
      NQueryIpFile,
      NextIpTimeout
    },
    {
      InitTcp,
      CreateTcpConnection,
      NQueryTcpFile,
      NextTcpTimeout
    },
    {
      InitIcmp,
      CreateIcmpConnection,
      NQueryIcmpFile,
      NextIcmpTimeout
    }
  };

struct PnetBlock PnetTable[NumPnetProtocols] =
				/* Physical net protocols table. 
				   NOTE: the prot field must be set in the
				   initNetProt() routine. */
  {
    {
      0,
      0,
      InitNetIp,
      RcvAllIp
    },
    {
      0,
      0,
      InitNetArp,
      RcvAllArp
    }
  };


int NetLevelProtocol[NumProtocols] =
				/* Id of net level protocol for each
				   connection protocol. */
  {
    IpNetProt, 			/* IP */
    IpNetProt, 			/* TCP */
    IpNetProt                   /* ICMP */
  };




/*
 * ActivateNetProtocol:
 * Sets the designated network level protocol as active in PnetTable.
 */

ActivateNetProtocol(prot)
    int prot;
  {
    PnetTable[prot].active = True;
  }




/*
 * DeactivateNetProtocol:
 * Sets the designated network level protocol as inactive in PnetTable.
 */

DeactivateNetProtocol(prot)
    int prot;
  {
    PnetTable[prot].active = False;
  }
