/************************************************************************/
/*		   (C) COPYRIGHT 1983,1984,1985,1986			*/
/*                         BOARD OF TRUSTEES				*/
/*                 LELAND STANFORD JUNIOR UNIVERSITY			*/
/*                    STANFORD, CA. 94305, U.S.A.			*/
/************************************************************************/

/*
 * Include file for physical network definitions.  
 * Maps general pnet definitions into ones specific to a particular network.
 */

#include <Vethernet.h>


#define ENET_MIN_PACKET 60	/* Minimum packet size for a 10Mb ethernet,
				   46 data + 2 type + 6 source + 6 dest 
				   The 3Mb minimum is smaller, so this can be
				   used for both. */

typedef Enet10Address PnetAddr;/* Physical network address type.
				   Use the larger of the two defns. */

int PnetType;			/* Specifies whether the server is running
				   on a 3Mb or a 10Mb network. 
				   10 => 10Mb, 3 => 3Mb. */


Enet3Address LocalPnetHost3Mb;	/* Physical network address of local host
				   for 3Mb case. */
Enet10Address LocalPnetHost10Mb;/* Physical network address of local host.
				   for 10Mb case. */

int SizeOfEnetHeader;		/* Size of an ethernet packet header.
				   Set this once rather than each time it is
				   used. */

PnetAddr BroadCastAddr;		/* Broadcast address */
