/************************************************************************/
/*		   (C) COPYRIGHT 1983,1984,1985,1986			*/
/*                         BOARD OF TRUSTEES				*/
/*                 LELAND STANFORD JUNIOR UNIVERSITY			*/
/*                    STANFORD, CA. 94305, U.S.A.			*/
/************************************************************************/

/*
 * Include file for protocol-independent definitions.
 */

#include "Vspinlock.h"
#include <Vioprotocol.h>
#include <Vnet.h>
#include "pnet.h"
#include "prot.h"


/*
 * General definitions
 */

typedef unsigned char   Bit8;
typedef unsigned short  Bit16;
typedef unsigned long   Bit32;

typedef int Boolean;
#define True 1
#define False 0

#define Null 0
#define Null16 (Bit16) 0
#define Null32 (Bit32) 0



#define	MAXPBUFSIZE	1100	/* Size of a packet buffer.  Should not be
				   larger than 1100 to avoid stack 
				   overflows. */

#define MAX_NET_INST 50		/* Maximum number of network connections
				   that can be handled. */
#define DirectoryInstance MAX_NET_INST
#define DirectoryFileId (DirectoryInstance<<1)+1
				/* Add one to make it read instance */
#define MAX_RING_BUFS 30	/* Maximum number of packets that can be
				   queued in a ring buffer.  This number
				   effectively is the maximum number of
				   packets that can be queued for any given
				   network connection. */

/*
 * Network connection instance states.
 */
#define READ_INST 1		/* Read instance active bit */
#define WRITE_INST 2		/* Write instance active bit */

#define MAX_SIGNED_INT ((int) 0x7fffffff)
				/* Largest nonnegative integer on a 32 bit
				   machine. */

/*
 * Network server events.
 */

#define LocalNetPktRcvd 0
#define OtherNetPktRcvd 1
#define NetTimeout 	2
#define NetSuicide 	3

/*
 * Network timer event types.
 */
#define ConnTimeout 0
#define InvalidConnOwner 1


/*
 * Record formats
 */

typedef struct pbuf		/* Packet buffer */
  {
    struct pbuf	*next;		/* link to next pbuf in a Queue */
    int	length;			/* number of valid data bytes */
    char *dataptr;		/* pointer to first valid data byte */
    unsigned unspecified[4];
    char data [MAXPBUFSIZE];	/* actual data bytes are in here .
				   NOTE: must be word-alligned. */
  } *PktBuf;

typedef struct			/* Queue header */
  {
	PktBuf	head;
	PktBuf	tail;
  } Queue;

typedef struct RingBufType	/* Ring buffer */
  {
    PktBuf pkt;
    struct RingBufType *next;
  } RingBufRec, *RingBuf;

typedef struct			/* Ring queue header */
  {
    RingBuf head;
    RingBuf tail;
  } RingQueue;

struct NetInstDescr		/* Network connection instance
				   descriptor. */
  {
    unsigned char inUse;
    int next;
    ProcessId ownerPid;		/* Process id of instance owner. */
    int prot;
    ProcessId pid;		/* Process id of process associated with this
				   instance. */
    unsigned tcbId;		/* Ptr or index to protocol-specific 
				   transmission control block. */
    int rblocksize;		/* Read instance block size. */
    int wblocksize;		/* Write instance block size. */
    int filelastbytes;
    int filelastblock;
    int filenextblock;
  };

/* internet address structures */

struct in_addr
  {
    union
      {
	struct { char b1,b2,b3,b4; } in8;
	struct { short w1,w2; } in16;
	long in32;
      } s_in_addr;
  };


/*
 * Various global variables
 */

int InternetDebug;		/* Debug flag: larger => more verbose */
short TimerDebug;		/* For debugging timer bugs */

int FreeBufferCount, TotalBufferCount;
				/* Number of allocated packet buffers that
				   are resp. on the free list and total in
				   the system. */

struct NetInstDescr NetInstTable[MAX_NET_INST+1];
				/* Network instance descriptor records. 
				   Extra one is for directory instance */
int NetInstHead, NetInstFree;

int Time0;			/* Initial seconds time when internet server
				   started up.  This is used to normalize the
				   current time (which is in clicks). */
int CurrentTime;		/* Current time. */
int NextTimeout;		/* Time of next timeout. */
ProcessId TimerPid;		/* Process id of the connection timeout
				   timer process. */
ProcessId timer1Id;		/* Connection cleanup timer */
int AllocBusyWait;		/* Number of buffer busy wait cycles */

/*
 * Tuning variables - see parms.c for defns.
 */

int BufAllocNum, BufAllocMax, MaxBufAllocNum, MaxBufAllocSaveQ;


/*
 * General macro definitions
 */

#define Max(a,b) ((a) >= (b)) ? (a) : (b)
#define Min(a,b) ((a) < (b)) ? (a) : (b)

#define FreeBuf(pkt) DeallocBuf(pkt)

#define CTime(s, c) ((s<<6) + (s<<5) + (s<<2) + c)
				/* Converts seconds and clicks to clicks. */

/*
 * Queueing macros.
 */

#define Empty(Q) (Q.head == NULL)

/*
 * Doubly-linked list manipulation routines.
 */

#define AddList(ptr, rec)			\
	/* Add rec after ptr. */		\
	{					\
	rec->prev = ptr;			\
	rec->next = ptr->next;			\
	(ptr->next)->prev = rec;		\
	ptr->next = rec;			\
	}

#define DeleteList(ptr)				\
	{					\
	(ptr->prev)->next = ptr->next;		\
	(ptr->next)->prev = ptr->prev;		\
	}

#define InitList(ptr)				\
	/* Make into a one-element list. */	\
	{					\
	ptr->prev = ptr;			\
	ptr->next = ptr;			\
	}

/*
 * Locking macros.
 */

#define LOCKID(lock,lockLocation,id)		\
	AcquireGlobalSpinLock(lock);		\
	lockLocation = id;

#define UNLOCK(lock,lockLocation)		\
	ReleaseGlobalSpinLock(lock);		\
	lockLocation = 0;
