/************************************************************************/
/*		   (C) COPYRIGHT 1983,1984,1985,1986			*/
/*                         BOARD OF TRUSTEES				*/
/*                 LELAND STANFORD JUNIOR UNIVERSITY			*/
/*                    STANFORD, CA. 94305, U.S.A.			*/
/************************************************************************/

/*
 * Internetserver miscellaneous routines.
 */

#include "net.h"
#include "internet.h"

extern ProcessId InternetServerPid;


/*
 * PacketCheck:
 * Checks to see if a packet has overwritten its boundaries.
 */

PacketCheck(packet)
    PktBuf packet;
  {
    if (packet->dataptr < packet->data)
      {
	printf("DING DING DING DING ---- packet->dataptr too small!!!\n");
/***/abort();
      }
    if ((packet->dataptr + packet->length) > (packet->data + MAXPBUFSIZE))
      {
	printf("DING DING DING DING ---- packet length too long!!!\n");
/***/abort();
      }
  }




/*
 * ExitInternetServer:
 * Tell internetserver to clean up and then commit suicide.
 */

ExitInternetServer()
  {
    Message msg;
    IoRequest *reqMsg = (IoRequest *)msg;

    if (InternetServerPid != 0)
      {
        reqMsg->requestcode = NetSuicide;
        Send(msg, InternetServerPid);
      }
  }


/*
 * PauseInternetServer:
 * Graceful shutdown of internetserver so that state of variables
 * can be inspected without new data arrving to muck things up.
 * Stops accepting any packets (all are tossed), and the timer process
 * is halted before debugger is entered.
 */

PauseInternetServer(s)
    char *s;
  {
    int i;

    for (i=0; i<NumPnetProtocols; i++)
	PnetTable[i].active = 0;	/* Stop accepting packets */
    printf("internetserver: internal error '%s' - please report to guru\n",s);
    abort();				/* Enter debugger */
  }


/*
 * inet_ntoa:
 * Convert an internet address to standard 4-part character string.
 */

#define L8(x)   (((int)x)&0xFF)

char *
inet_ntoa(ad)
	struct in_addr ad;
  {
    static char b[18];
    register char *p;

    p = (char *)&ad;
    sprintf(b, "%d.%d.%d.%d",L8(p[0]),L8(p[1]),L8(p[2]),L8(p[3]));
#ifdef  LITTLE_ENDIAN
    sprintf(b, "%d.%d.%d.%d",L8(p[3]),L8(p[2]),L8(p[1]),L8(p[0]));
#endif  LITTLE_ENDIAN
    return (b);
  }
    

