/************************************************************************/
/*		   (C) COPYRIGHT 1983,1984,1985,1986			*/
/*                         BOARD OF TRUSTEES				*/
/*                 LELAND STANFORD JUNIOR UNIVERSITY			*/
/*                    STANFORD, CA. 94305, U.S.A.			*/
/************************************************************************/

/*
 * Internet server invocation program.
 * Runs the internet server in its own team space.
 */

#include <Vio.h>
#include <Vteams.h>

extern LogicalPid;		/* In case we want to use non-standard */

main(argc, argv)
    int argc;
    char **argv;
  {
    int nArg = 1;
    int localFlag = 1;		/* True if server should be local only */
    int debugFlag = 0;

    ChangeTeamPriority(0, FOREGROUND); 

    while (nArg < argc)
      {
	if (strcmp(argv[nArg], "-g") == 0)
	  {
	    localFlag = 0;	/* Server should be global. */
	  }
	else if (strcmp(argv[nArg], "-d") == 0)
	  {
	    debugFlag = 1;		/* Default if no numeric arg */
	    if (nArg+1 < argc)
	      {
		if (strcmp(argv[nArg][0], "-") == 0)
		    debugFlag = atoi(argv[++nArg]);
	      }
	  }
	else if (strcmp(argv[nArg], "-lpid") == 0)
	  {
	    LogicalPid = atoi(argv[++nArg]);
	  }
	else
	  {
	    printf("ERROR - unknown argument '%s' ignored.\n", argv[nArg]);
	    printf("  usage: internetserver [-g] [-d]\n");
	    printf("      Note: use 'inquery' command to inspect innards\n");
	  }
	nArg++;
      }
    InitInternetServer(localFlag, debugFlag);
  }
