/************************************************************************/
/*		   (C) COPYRIGHT 1983,1984,1985,1986			*/
/*                         BOARD OF TRUSTEES				*/
/*                 LELAND STANFORD JUNIOR UNIVERSITY			*/
/*                    STANFORD, CA. 94305, U.S.A.			*/
/************************************************************************/

/*
 * Top-level routines for the ICMP protocol
 */


#include "net.h"
#include "internet.h"
#include <sys/time.h>



extern int NetLevelProtocol[];
extern PktBuf AllocBuf();
extern char *inet_ntoa();


ProcessId icmpPid;
char IcmpMsgTypeNames[17][17] = 
  {
    "Echo Reply",
    "?? Type 1 ??",
    "?? Type 2 ??",
    "Dest Unreachable",
    "Source Quench",
    "Redirect",
    "?? Type 6 ??",
    "?? Type 7 ??",
    "Echo",
    "?? Type 9 ??",
    "?? Type 10 ??",
    "Time Exceeded",
    "Parm Problem",
    "Timestamp",
    "Timestamp Reply",
    "Info Request",
    "Info Reply"
  };


/* InitIcmp:
 *    Creates the IcmpProcess
 */


InitIcmp()
{
    int i;
    int IcmpProcess();

    firstitem = NULL;

    icmpPid = Create(2,IcmpProcess,IcmpStackSize);

    if(icmpPid == 0) {
	if(InternetDebug) {
	    printf("Couldn't Create IcmpProcess.\n");
	}
	return(NO_MEMORY);
    }

    if(!Ready(icmpPid,0)) {
	printf("Couldn't Ready IcmpProcess.\n");
	ExitInternetServer();
    }


    /* This is to always hold IP active */

    AllocNetInst(IcmpProt,icmpPid,icmpPid,0,0,0);

    return(NO_REPLY);
			
}



/* CreateIcmpConnection:
 *    There is no need for such a process, except that a so-named process
 * must exist in the FunctionTable structure.
 */


CreateIcmpConnection()
{
    return(REQUEST_NOT_SUPPORTED);
}



/* NQueryIcmpFile:
 *    There is no need for such a process, except that a so-named process
 * must exist in the FunctionTable structure.
 */


NQueryIcmpFile(msg,pid)
Message msg;
ProcessId pid;
{
    return(REQUEST_NOT_SUPPORTED);
}



/* NextIcmpTimeout:
 */


NextIcmpTimeout(dummy)
unsigned dummy;
{
    if(firstitem != NULL) {
	return(firstitem->ts + REPLYTIMEOUT);
    }
    else {
	return(MAX_SIGNED_INT);
    }
}    




/* IcmpProcess:
 *    Here is the main IcmpProcess that waits for a message that an Icmp
 * packet need to be sent, or has been received.  
 */


IcmpProcess()
{

    struct listitem *malloc();
    struct listitem *tempitem;
    struct listitem *previtem;
    struct listitem *newitem;
    struct listitem *item;
    SystemCode reply;
    ProcessId replypid;
    ProcessId pid;
    Message msg;
    Requestpak *req = (Requestpak *) msg;
    Replypak *replymsg = (Replypak *) msg;
    int sec, click;
    int i,j;
    IpAddr replyinghost;


    tempitem = NULL;
    newitem = NULL;
    previtem = NULL;
    item = NULL;

    while(1) {
	pid = Receive(req);


	switch(req->requestcode) {
	    case NetTimeout:

		reply = IcmpTimer();
		break;

	    case SEND_ICMP:

		reply = SendIcmpPacket(req);

		switch(req->icmptype) {
		case IcmpEcho:
		case IcmpTimestamp:
		case IcmpInfoRequest:
		    if(firstitem == NULL) {
			firstitem = malloc(sizeof (struct listitem));
			if (firstitem == NULL) {
			    reply = NO_MEMORY;
			}
			else {
			    firstitem->savePid  = pid;
			    sec = GetTime(&click) - Time0;
			    firstitem->ts = CTime(sec,click);
			    firstitem->host = req->pktdest;
			    firstitem->next = NULL;
		            reply = NO_REPLY;
			}
		    }
		    else {
			item = firstitem;
			while(item->next != NULL) item = item->next;
			newitem = malloc(sizeof (struct listitem));
			if (newitem == NULL)
			    reply = NO_MEMORY;
			else {
			    newitem->savePid = pid;
			    sec = GetTime(&click) - Time0;
			    newitem->ts = CTime(sec,click); 
			    newitem->host = req->pktdest;
			    newitem->next = NULL;
			    item->next = newitem;
		            reply = NO_REPLY;
			}
		    }
		    break;
		default:
		    break;
		}
		break;

	    case RECEIVE_ICMP:

		replymsg->replycode = OK;
		Reply(replymsg,pid);
		ReceiveIcmpPacket(req);
		reply = NO_REPLY;

		switch(req->icmptype) {
		    case IcmpEchoReply:
		    case IcmpTimestampReply:
		    case IcmpInfoReply:

			replyinghost = req->pktdest;

			if(firstitem == NULL) {
			}
			else {
			    tempitem = firstitem;
			    if (tempitem->host == replyinghost) {
				firstitem = firstitem->next;
				Reply(req,tempitem->savePid);
				free (tempitem);
			    }
			    else {
			        while((tempitem != NULL) &&
				    (tempitem->host != replyinghost)) {
			            previtem = tempitem;
				    tempitem = tempitem->next;
				}
				if(tempitem == NULL) {
				    /* Don't reply */
				}
				else {
				    previtem->next = tempitem->next;
				    Reply(req,tempitem->savePid);
				    free(tempitem);
				}
			    }
			}
			break;
		    default:
			break;
		}
		break;

	    default:
		reply = NO_REPLY;
		break;
	}

	if(reply != NO_REPLY) {
	    replymsg->replycode = reply;
	    Reply(replymsg,pid);
	}
    }
}




/*
 * IcmpTimer
 * Routine to reply to any timed-out outstanding pings,
 * timestamps or infos.  
 */

IcmpTimer()
{
    int sec,click, currenttime;
    int i;
    Message msg;
    Replypak *noreply = (Replypak *) msg;
    struct listitem *searchitem;
    struct listitem *tempitem;
    int rc;
    ProcessId replyrc;

    tempitem = NULL;
    searchitem = NULL;

    if (firstitem == NULL) return(OK);

    searchitem = firstitem;

    sec = GetTime(&click) - Time0;
    currenttime = CTime(sec,click);
    while ((searchitem != NULL) && 
      (currenttime - searchitem->ts >= REPLYTIMEOUT)) {	
        tempitem = searchitem;
	noreply->replycode = TIMEOUT_ICMP;
    	noreply->icmptype = Undefinedtype;
	noreply->pid = searchitem->savePid;
	searchitem = searchitem->next;
	free(tempitem);
	replyrc = Reply(noreply,noreply->pid); 
    }
    firstitem = searchitem;
    return(OK);
}


/*
 * SendIcmpPacket
 *    This routine sends an Icmp packet of whatever type that is specified
 * in the icmptype field of req.
 */

SendIcmpPacket(req)
Requestpak *req;
{

    PktBuf packet;
    char *saveDataptr;
    int saveLength;
    SystemCode rc;
    IpHdrPtr iphdr;
    IpAddr source,destination;
    IcmpTSPktPtr tsptr;
    Bit32 time;
    unsigned MilliTime();
    int i;


    if((FreeBufferCount <= 1) && (TotalBufferCount >= MaxBufAllocNum - 1)) {
	return(RETRY);
    }

    packet = AllocBuf();

    if(packet == NULL) {
	return(RETRY);
    }

    if(packet != NULL) {
	packet->dataptr = &(packet->data[MAXPBUFSIZE - MaxPacketDataLength]);
    }


    switch(req->icmptype) {

	case IcmpDestUnreachable:
	    iphdr = (IpHdrPtr) req->recdpktptr;
    	    packet->length = 
		sizeof(struct IcmpCommonHeader)+((iphdr->ver_ihl & 0x0f)<<2) +
		sizeof(struct DataBufType);
	    FillDUHeader(packet,iphdr);
	    packet->unspecified[3] = req->pktdest;
	    break;

	case IcmpSourceQuench:
	    iphdr = (IpHdrPtr) req->recdpktptr;
    	    packet->length = 
		sizeof(struct IcmpCommonBufType)+((iphdr->ver_ihl & 0x0f)<<2) +
		sizeof(struct DataBufType);
	    FillSQHeader(packet,iphdr);
	    packet->unspecified[3] = req->pktdest;
	    break;

	case IcmpEcho:
    	    packet->length = sizeof(struct IcmpEchoBufType);
	    FillEchoHeader(packet);
	    packet->unspecified[3] = req->pktdest;
	    break;

	case IcmpTimeExceeded:
	    iphdr = (IpHdrPtr) req->recdpktptr;
    	    packet->length = 
		sizeof(struct IcmpCommonBufType)+((iphdr->ver_ihl & 0x0f)<<2) +
		sizeof(struct DataBufType);
	    FillTEHeader(packet,iphdr);
	    packet->unspecified[3] = req->pktdest;
	    break;

	case IcmpParameterProblem:
	    iphdr = (IpHdrPtr) req->recdpktptr;
    	    packet->length = 
		sizeof(struct IcmpCommonBufType)+((iphdr->ver_ihl & 0x0f)<<2) +
		sizeof(struct DataBufType);
	    FillPPHeader(packet,iphdr);
	    packet->unspecified[3] = req->pktdest;
	    break;

	case IcmpTimestamp:
    	    packet->length = sizeof(struct IcmpTSBufType);
	    FillTSHeader(packet);
	    packet->unspecified[3] = req->pktdest;
	    break;

	case IcmpInfoRequest:
    	    packet->length = sizeof(struct IcmpIRBufType);
	    FillInfoRequestHeader(packet);
	    packet->unspecified[3] = (req->pktdest & NETFIELDB);
	    break;

	default:

	    break;

    }


    saveDataptr = packet->dataptr;
    saveLength = packet->length;

    if (req->icmptype == IcmpInfoRequest) 
	source = LocalIpHost & NETFIELDB;
    else 
        source = LocalIpHost;
    
    destination = packet->unspecified[3];

    rc = WriteIp(source,destination,ICMPprot,0,0,30,packet,0,0);

    packet->dataptr = saveDataptr;
    packet->length = saveLength;

    if (rc != OK)
      {
	if (InternetDebug)
	  {
	    printf("Icmp: error in WriteIp (%s)\n", ErrorString(rc));
	  }
      }

    FreeBuf(packet);
    return(rc);
}






/* ReceiveIcmpPacket:
 *    This routine decides what kind of Icmp Packet the internet server 
 * has received.
 */



ReceiveIcmpPacket(req)
Requestpak *req;
{
    PktBuf packet;


	packet = req->recdpktptr;

	    switch(req->icmptype) {

		case IcmpEchoReply:
		    GotEchoReply(packet);
		    break;

		case IcmpEcho:
		    GotEcho(packet);
		    break;

		case IcmpTimestamp:
		    GotTimestamp(packet);
		    break;

		case IcmpTimestampReply:
		    GotTimestampReply(packet);
		    break;

		case IcmpInfoRequest:
		    GotInfoRequest(packet);
		    break;

		case IcmpInfoReply:
		    GotInfoReply(packet);
		    break;

		default:
		    if(InternetDebug)
		      printf("RcvIcmpPacket:Unknown type %d\n",req->icmptype);
		    break;

	    }

    return(OK);
}



/* IcmpCheckSum:
 *    Computes the one's complement sum of all 16-bit words in the buffer.
 */


int IcmpCheckSum(ibuf,ilen)
short *ibuf;
int ilen;
{
    register unsigned short *buf = (unsigned short *)ibuf;
    register int len = ilen;
    register int sum;

    sum = 0;
    while(len-- > 0) {
	sum += *buf++;
	if (sum & 0x10000)
	    sum -= 0xFFFF;
    }
    return(sum & 0xFFFF);
}







/* This is the start of the routines that process received Icmp packets...
 */




GotEchoReply(packet)
PktBuf packet;
{
    Message msg;
    Replypak *reply = (Replypak *) msg;

    if (InternetDebug)
        printf("Icmp Echo Reply received from %s.\n",
	    inet_ntoa(packet->unspecified[0]));


    FreeBuf(packet);

}



    
GotEcho(packet)
PktBuf packet;
{
    char *saveDataptr;
    int saveLength;
    int rc;

    if(InternetDebug)
        printf("Icmp Echo received from %s.\n",
	    inet_ntoa(packet->unspecified[0]));
    
    FillEchoReplyHeader(packet);

    saveDataptr = packet->dataptr;
    saveLength = packet->length;

    if(InternetDebug)
        printf("Sending Echo Reply to %s.\n",
	    inet_ntoa(packet->unspecified[0]));

    rc = WriteIp(LocalIpHost,packet->unspecified[0],ICMPprot,0,0,30,packet,0,0);

    packet->dataptr = saveDataptr;
    packet->length = saveLength;

    FreeBuf(packet);

    if(rc != OK) {
	if(InternetDebug) {
	    printf("Icmp: error in WriteIp (%s)\n", ErrorString(rc));
	}
    }


}




GotTimestamp(packet)
PktBuf packet;
{
    char *saveDataptr;
    int saveLength;
    IcmpTSPktPtr ptr;
    unsigned MilliTime();
    int rc;


    if(InternetDebug)
        printf("Icmp Timestamp received from %s.\n",
	    inet_ntoa(packet->unspecified[0]));

    ptr = IcmpTSPkt(packet);
    ptr->hdr.receiveTS = MilliTime();

    saveDataptr = packet->dataptr;
    saveLength = packet->length;

    FillTSReplyHeader(packet);

    rc=WriteIp(LocalIpHost,packet->unspecified[0],ICMPprot,0,0,30,packet,0,0);

    packet->dataptr = saveDataptr;
    packet->length = saveLength;

    FreeBuf(packet);

    if(rc != OK) {
	if(InternetDebug) {
	    printf("Icmp: error in WriteIp (%s)\n", ErrorString(rc));
	}
    }

}




GotTimestampReply(packet)
PktBuf packet;
{
    Message msg;
    Replypak *reply = (Replypak *) msg;
    IcmpTSPktPtr pkt;

    pkt = IcmpTSPkt(packet);


    if(InternetDebug) {
        printf("Icmp Timestamp Reply received from %s.\n",
	    inet_ntoa(packet->unspecified[0]));

        printf("Timestamp sent       %10x\n",pkt->hdr.originTS);
        printf("Timestamp received   %10x\n",pkt->hdr.receiveTS);
        printf("Timestamp Reply sent %10x\n",pkt->hdr.transmitTS);
    }

    FreeBuf(packet);

}




GotInfoRequest(packet)
PktBuf packet;
{

    char *saveDataptr;
    int saveLength;
    int rc;

    if(InternetDebug)
        printf("Icmp Information Request received from %s.\n",
	    inet_ntoa(packet->unspecified[0]));
    
    FillInfoReplyHeader(packet);

    saveDataptr = packet->dataptr;
    saveLength = packet->length;

    rc=WriteIp(LocalIpHost,packet->unspecified[0],ICMPprot,0,0,30,packet,0,0);

    packet->dataptr = saveDataptr;
    packet->length = saveLength;

    FreeBuf(packet);

    if(rc != OK) {
	if(InternetDebug) {
	    printf("Icmp: error in WriteIp (%s)\n", ErrorString(rc));
	}
    }

}





GotInfoReply(packet)
PktBuf packet;
{
    IcmpIRPktPtr pkt;
    Message msg;
    Replypak *reply = (Replypak *) msg;

    pkt = IcmpIRPkt(packet);

    if(InternetDebug)
        printf("Icmp Information Reply received from %s.\n",
	    inet_ntoa(packet->unspecified[0]));

    FreeBuf(packet);

}




/* Here's where you fill in all the headers of outgoing packets */


 FillEchoReplyHeader(packet)
 PktBuf packet;
 {
    IcmpEchoPktPtr ptr;
    int varlength;

    ptr = IcmpEchoPkt(packet);

    ptr->hdr.type = IcmpEchoReply;
    ptr->hdr.checkSum = Null16;

    varlength = packet->length;
    ptr->hdr.checkSum =
	~IcmpCheckSum(ptr,(varlength + 1) >> 1);
}




 FillDUHeader(packet,iphdr)
 PktBuf packet;
 IpHdrPtr iphdr;
 {
    IcmpCommonPktPtr ptr;
    char *ipptr,*ipptrinstruct;
    int length;
    struct iphdr *pointer;

    if (InternetDebug)
	printf("Sending Icmp Destination Unreachable to %s\n",
	    inet_ntoa(iphdr->srcAdr));

    ptr = IcmpCommonPkt(packet);

    ptr->hdr.type = IcmpDestUnreachable;
    ptr->hdr.code = DUcodePortUnreachable;
    ptr->hdr.checkSum = Null16;
    ptr->hdr.unused = Null32;

    ipptr = (char *) iphdr;
    pointer = &(ptr->ipheader);
    ipptrinstruct = (char *) pointer;

    Copy(ipptrinstruct,ipptr,(((iphdr->ver_ihl & 0x0f)<<2) + 
	sizeof(struct DataBufType)));

    length = sizeof(struct IcmpCommonHeader)+((iphdr->ver_ihl & 0x0f)<<2) +
		sizeof(struct DataBufType);

    ptr->hdr.checkSum =
	~IcmpCheckSum(ptr,(length + 1) >> 1);

}





 FillSQHeader(packet,iphdr)
 PktBuf packet;
 IpHdrPtr iphdr;
 {
    IcmpCommonPktPtr ptr;
    char *ipptr,*ipptrinstruct;
    int length;
    struct iphdr *pointer;

    if (InternetDebug) printf("Sending Icmp Source Quench\n");

    ptr = IcmpCommonPkt(packet);

    ptr->hdr.type = IcmpSourceQuench;
    ptr->hdr.code = SQcode;
    ptr->hdr.checkSum = Null16;
    ptr->hdr.unused = Null32;

    ipptr = (char *) iphdr;
    pointer = &(ptr->ipheader);
    ipptrinstruct = (char *) pointer;

    Copy(ipptrinstruct,ipptr,(((iphdr->ver_ihl & 0x0f)<<2) + 
	sizeof(struct DataBufType)));

    length = sizeof(struct IcmpCommonHeader) + ((iphdr->ver_ihl & 0x0f)<<2) +
		sizeof(struct DataBufType);

    ptr->hdr.checkSum =
	~IcmpCheckSum(ptr,(length + 1) >> 1);


}




FillEchoHeader(packet)
 PktBuf packet;
 {
    IcmpEchoPktPtr ptr;

    ptr = IcmpEchoPkt(packet);

    ptr->hdr.type = IcmpEcho;
    ptr->hdr.code = Ecode;
    ptr->hdr.checkSum = Null16;
    ptr->hdr.identifier = Null16;
    ptr->hdr.seqnum = Null16;


    ptr->hdr.checkSum =
	~IcmpCheckSum(ptr,(sizeof(struct IcmpEchoBufType) + 1) >> 1);

}








 FillTEHeader(packet,iphdr)
 PktBuf packet;
 IpHdrPtr iphdr;
 {
    IcmpCommonPktPtr ptr;
    char *ipptr,*ipptrinstruct;
    int length;
    struct iphdr *pointer;

    if(InternetDebug) printf("Sending Icmp Time Exceeded\n");

    ptr = IcmpCommonPkt(packet);

    ptr->hdr.type = IcmpTimeExceeded;
    ptr->hdr.code = TEcodeTimeToLive;
    ptr->hdr.checkSum = Null16;
    ptr->hdr.unused = Null32;


    ipptr = (char *) iphdr;
    pointer = &(ptr->ipheader);
    ipptrinstruct = (char *) pointer;

    Copy(ipptrinstruct,ipptr,(((iphdr->ver_ihl & 0x0f)<<2) + 
	sizeof(struct DataBufType)));

    length = sizeof(struct IcmpCommonHeader) + ((iphdr->ver_ihl & 0x0f)<<2) +
		sizeof(struct DataBufType);

    ptr->hdr.checkSum =
	~IcmpCheckSum(ptr,(length + 1) >> 1);


}






 FillPPHeader(packet,iphdr)
 PktBuf packet;
 IpHdrPtr iphdr;
 {
    IcmpPPPktPtr ptr;
    char *ipptr,*ipptrinstruct;
    int length;
    struct iphdr *pointer;

    if(InternetDebug) printf("Sending Icmp Parameter Problem\n");

    ptr = IcmpPPPkt(packet);

    ptr->hdr.type = IcmpParameterProblem;
    ptr->hdr.code = PPcodePointerToError;
    ptr->hdr.checkSum = Null16;
    ptr->hdr.pointer = 0;
    ptr->hdr.unused8 = 0;
    ptr->hdr.unused16 = Null16;

    ipptr = (char *) iphdr;
    pointer = &(ptr->ipheader);
    ipptrinstruct = (char *) pointer;

    Copy(ipptrinstruct,ipptr,(((iphdr->ver_ihl & 0x0f)<<2) + 
	sizeof(struct DataBufType)));

    length = sizeof(struct IcmpCommonHeader) + ((iphdr->ver_ihl & 0x0f)<<2) +
		sizeof(struct DataBufType);

    ptr->hdr.checkSum =
	~IcmpCheckSum(ptr,(length + 1) >> 1);

}



 FillTSHeader(packet)
 PktBuf packet;
 {
    IcmpTSPktPtr ptr;
    unsigned MilliTime();

    ptr = IcmpTSPkt(packet);

    ptr->hdr.type = IcmpTimestamp;
    ptr->hdr.code = TScode;
    ptr->hdr.checkSum = Null16;
    ptr->hdr.identifier = Null16;
    ptr->hdr.seqnum = Null16;
    ptr->hdr.originTS = MilliTime();
    ptr->hdr.receiveTS = Null32;
    ptr->hdr.transmitTS = Null32;


    ptr->hdr.checkSum =
	~IcmpCheckSum(ptr,(sizeof(struct IcmpTSBufType) + 1) >> 1);

}



 FillTSReplyHeader(packet)
 PktBuf packet;
 {
    IcmpTSPktPtr ptr;
    unsigned MilliTime();

    ptr = IcmpTSPkt(packet);

    ptr->hdr.type = IcmpTimestampReply;
    ptr->hdr.checkSum = Null16;
    ptr->hdr.transmitTS = MilliTime();


    ptr->hdr.checkSum =
	~IcmpCheckSum(ptr,(sizeof(struct IcmpTSBufType) + 1) >> 1);

}

 FillInfoRequestHeader(packet)
 PktBuf packet;
 {
    IcmpIRPktPtr ptr;

    ptr = IcmpIRPkt(packet);

    ptr->hdr.type = IcmpInfoRequest;
    ptr->hdr.code = IRcode;
    ptr->hdr.checkSum = Null16;
    ptr->hdr.identifier = Null16;
    ptr->hdr.seqnum = Null16;


    ptr->hdr.checkSum =
	~IcmpCheckSum(ptr,(sizeof(struct IcmpIRBufType) + 1) >> 1);

}



 FillInfoReplyHeader(packet)
 PktBuf packet;
 {
    IcmpIRPktPtr ptr;

    ptr = IcmpIRPkt(packet);

    ptr->hdr.type = IcmpInfoReply;
    ptr->hdr.checkSum = Null16;

    ptr->hdr.checkSum =
	~IcmpCheckSum(ptr,(sizeof(struct IcmpIRBufType) + 1) >> 1);

}




/*
 * MilliTime
 * Returns the current time, since midnight today, in milliseconds.
 */

unsigned MilliTime()
{

    unsigned value,time,sec,clicks;
    struct tm *tm1;

    sec = GetTime(&clicks);

    value = sec % (24*60*60);
    time = (value*1000) + (clicks*10);
    return(time);

}


/*
 * TcpRcvIcmp
 * Processes incoming ICMP packets that are associated with specific
 * TCP connections.
 */



TcpRcvIcmp(pTcb,packet)
TcpTcbPtr pTcb;
PktBuf packet;
{
    IcmpCommonPktPtr commonpkt;

    commonpkt = IcmpCommonPkt(packet);

    switch(commonpkt->hdr.type) {
	case IcmpDestUnreachable:

	    if(InternetDebug)
	        printf("Icmp Destination unreachable received\n");
	    IcmpCloseConnection(pTcb,packet,NOT_FOUND);
	    break;

	case IcmpSourceQuench:

	    if(InternetDebug)
	        printf("Icmp Source Quench received\n");
	    DoIcmpSQ(pTcb,packet);
	    break;

	case IcmpRedirect:

	    if(InternetDebug)
	        printf("Icmp Redirect received\n");
	    DoIcmpRedirect(pTcb,packet);
	    break;

	case IcmpTimeExceeded:

	    if(InternetDebug)
	        printf("Icmp Time Exceeded received\n");
	    DoIcmpTE(pTcb,packet);
	    break;

	case IcmpParameterProblem:

	    if(InternetDebug)
	        printf("Icmp Parameter Problem received\n");
	    IcmpCloseConnection(pTcb,packet,INTERNAL_ERROR);
	    break;

	default:

	    if(InternetDebug)
	        printf("Unknown icmp type %d\n",commonpkt->hdr.type);
	    break;

    }
}




/*
 * DoIcmpTE
 * Handles Icmp Time Exceeded packet
 */


DoIcmpTE(pTcb,packet)
TcpTcbPtr pTcb;
PktBuf packet;
{

    int found;
    IcmpCommonPktPtr commonpkt;
    TcpPktPtr tcppkt;
    PktBuf retranspkt;
    int length;
    char *ptr;
    DataPtr dataptr;

    commonpkt = IcmpCommonPkt(packet);
    found = 0;

    if(pTcb->instState & TCP_CONN_CLOSED) {
	return;
    }
    else if (Empty(pTcb->q[RetransQueue])) {
	return;
    }
    else {
	retranspkt = pTcb->q[RetransQueue].head;
	while((retranspkt != NULL) && (found == 0)) {
	    tcppkt = TcpPkt(retranspkt);

	    length = (commonpkt->ipheader.ver_ihl & 0x0f) << 2;
	    ptr = (char *) commonpkt;
	    ptr = ptr + length + 8;
	    dataptr = (DataPtr) ptr;

	    if (tcppkt->hdr.sequenceNumber == dataptr->next32) {
		found = 1;
		if (retranspkt->unspecified[3] < TERetransLimit) {
		    retranspkt->unspecified[3] += 1;
		    SendIp(pTcb,retranspkt,pTcb->foreignSocket.host);
		}
		else {
	            if(InternetDebug)
		        printf("Time Exceeded, Retransmit Limit Exceeded\n");
		    IcmpCloseConnection(pTcb,packet,TIMEOUT);
		}
	    }
	    else {
		retranspkt = retranspkt->next;
	    }
	}
    }
}



/*
 * DoIcmpSQ
 * Dummy routine to handle Icmp Source Quench packets someday
 */

DoIcmpSQ(pTcb,packet)
TcpTcbPtr pTcb;
PktBuf packet;
{

/* Don't know what to do with these yet */

    FreeBuf(packet);
}




/*
 * DoIcmpRedirect
 * Dummy routine to handle Icmp Redirect packets someday
 */

DoIcmpRedirect(pTcb,packet)
TcpTcbPtr pTcb;
PktBuf packet;
{

/* Don't know what to do with these yet */

    FreeBuf(packet);
}





/* 
 * IcmpCloseConnection
 * Frees an Icmp packet and closes the associated TCP connection
 */

IcmpCloseConnection(pTcb,packet,errCode)
TcpTcbPtr pTcb;
PktBuf packet;
SystemCode errCode;
{

    FreeBuf(packet);
    DeallocateTcb(pTcb,errCode);
}
