/************************************************************************/
/*		   (C) COPYRIGHT 1983,1984,1985,1986			*/
/*                         BOARD OF TRUSTEES				*/
/*                 LELAND STANFORD JUNIOR UNIVERSITY			*/
/*                    STANFORD, CA. 94305, U.S.A.			*/
/************************************************************************/

/*
 * Address Resolution Protocol package.
 *
 * NOTE: 10Mb ethernet addresses are assumed.
 */


#include "net.h"
#include "internet.h"
#include "arp.h"


#define ARP_TIME_INTERVAL 50


extern PktBuf AllocBuf();
extern SystemCode WritePnet();


/*
 * InitNetArp:
 * Initialize Arp resolution package.
 */

InitNetArp()
  {
    PnetTable[ArpNetProt].prot = ArpEtherType;
    ActivateNetProtocol(ArpNetProt);
  }


/*
 * RcvAllArp:
 * Implements the Address Resolution Protocol.
 * Answers ARP packets asking for the local host's hardware address and
 * updates routing tables with ARP reply packet information.
 */

RcvAllArp(packet)
    PktBuf packet;
  {
    ArpPktPtr arp = (ArpPktPtr) packet->dataptr;
    SystemCode status;

#ifdef  LITTLE_ENDIAN
    SwapARP(arp);
#endif  LITTLE_ENDIAN
    /* Reply to the ARP request if appropriate. */
    if ((arp->pro == IpEtherType10Mb) && (arp->tpa == LocalIpHost))
      {
        if (arp->op == ARP_REQUEST)
	  {
	    arp->tha = arp->sha;
	    arp->tpa = *(IpAddr *)&arp->spa[0];
	    arp->sha = LocalPnetHost10Mb;
	    *(IpAddr *)&arp->spa[0] = LocalIpHost;
	    arp->op = ARP_REPLY;
	    status = WritePnet(packet, &(arp->tha), ArpNetProt);
	    if (InternetDebug && (status != OK))
	      {
		printf("ERROR - WritePnet failed from ARP routine.\n");
		Flush(stdout);
	      }
	  }
	else			/* Reply to an arp request we sent out
				   earlier. */
	  {
	    UpdateIpRoutingTable(&(arp->sha), (IpAddr *)&arp->spa[0]);
	  }
      }

    DeallocBuf(packet);
  }


/*
 * ArpRequest:
 * Sends out an ARP request packet for the designated IP address.  Delays
 * for a while so that the reply (hopefully) will have returned and been
 * processed by RcvAllArp().
 */

ArpRequest(ia)
    IpAddr ia;
  {
    PktBuf packet;
    ArpPktPtr arp;
    SystemCode status;

    packet = AllocBuf();
    while (packet == NULL)
      {
	Delay(0,1);
	AllocBusyWait++;
	packet = AllocBuf();
      }
    packet->dataptr = packet->data + SizeOfEnetHeader;
    packet->length = sizeof(struct ArpPkt);
    arp = (ArpPktPtr) packet->dataptr;
    arp->hrd = ARP_ETHER_HARDWARE;
    arp->pro = IpEtherType10Mb;
    arp->hln = 6;
    arp->pln = 4;
    arp->op = ARP_REQUEST;
    arp->sha = LocalPnetHost10Mb;
    *(IpAddr *)&arp->spa[0] = LocalIpHost;
    Zero(&arp->tha, sizeof arp->tha);
    arp->tpa = ia;
    status = WritePnet(packet, &BroadCastAddr, ArpNetProt);
    if (InternetDebug && (status != OK))
      {
	printf("ERROR - WritePnet failed in ArpRequest routine.\n");
	Flush(stdout);
      }
    DeallocBuf(packet);

    Delay(0, ARP_TIME_INTERVAL);
    
    return;
  }
