#include <Venviron.h>
#include <Vio.h>
#include <Vdirectory.h>
#include <Vteams.h>

extern SystemCode GetContextId();

/*
 * MapRemoteHost:
 * Maps a string name for a host into its corresponding team server 
 * process-id.  0 is returned if no mapping can be performed.
 */
ProcessId MapRemoteHost(host)
    char *host;
  {
    char namebuf[100];
    ContextPair ctx;

    strcpy(namebuf, "[team/");
    strcat(namebuf, host);
    if (GetContextId(namebuf, &ctx) != OK) return 0;

    return(ctx.pid);
  }


int GetHostName(teamServerPid, hostName)
    ProcessId teamServerPid;
    char *hostName;
    /* Queries the team server "teamServerPid", to find the name of the host 
     * on which it executes.  The name is returned in "hostName".
     * This routine returns 0 iff the query fails.
     */
  {
    Message msg;
    register UpdateHostStatusRequest *updaterequest
    				 = (UpdateHostStatusRequest *) msg;
    HostStatusRecord hoststat;

    updaterequest->requestcode = UpdateRequest;
    updaterequest->bufferptr = (char *) &hoststat;
    updaterequest->bytecount = sizeof (HostStatusRecord);
    updaterequest->requesttype = 3;		/* must be defined */
    if (Send(msg, teamServerPid) == 0)
        return(0);
    if (updaterequest->requestcode != OK)
        return(0);
    strcpy(hostName, hoststat.hostName);
    return(1);
  }
