/************************************************************************/
/*									*/
/*			(C) COPYRIGHT 1983				*/
/*			BOARD OF TRUSTEES				*/
/*			LELAND STANFORD JUNIOR UNIVERSITY		*/
/*			STANFORD, CA. 94305, U.S.A.			*/
/*									*/
/************************************************************************/

/*
 * History mechanism for V shell.
 * Marvin Theimer.
 *
 * Marvin Theimer, Aug/83
 *	File first created.
 *
 * Handle !! when no history. Per Bothner. Oct/83
 */

#include <Vio.h>
#include "sh.h"

extern char *strsave();

/*
 * InitHistory:
 * Initialize history mechanism.
 */

InitHistory(h)
    HistoryRec *h;
  {
    int i;

    h->nextCmdnum = 1;
    for (i = 0; i < MaxHistCmds; i++)
      {
	h->cmds[i] = NULL;
      }
    h->nextCmd = 0;
  }

/*
 * DoHistory:
 * Either replaces the input line with the appropriate history line or
 * enters the line as a new line in the history.  
 * Returns -1 if an error occurs, 0 if no history reference is encountered,
 * and the length of the history line designated if one is encountered.
 */

int DoHistory(lineBuf, h)
    char lineBuf[];
    HistoryRec *h;
  {
    int 	j, flag;
    int		i=0;
    char	ch;
    char 	*s1, *s2;
    int		cmdnum;

    ch = lineBuf[0];

    /* eat up all initial white space */
    while( ( (ch==' ') || (ch=='\t') ) && (ch!='\n') )
	ch = lineBuf[++i];

    if (lineBuf[i] == '!')	/* This is a command history invocation. */
      {
	if (lineBuf[i+1] == '!')    /* Reexecute the last command. */
	  {
	    if (h->nextCmd != 0)
		j = h->nextCmd - 1;
	    else
	      {
		j = MaxHistCmds - 1;
		if (h->cmds[j] == NULL)
		    return -1; /* no previous command */
	      }
	  }
	else if( ( (lineBuf[i+1] >= '0') && (lineBuf[i+1] <= '9') )
		|| (lineBuf[i+1] == '-') )
	  {
	    sscanf( lineBuf+i, "!%8d", &cmdnum );
	    if( cmdnum < 0 )
		cmdnum = cmdnum + h->nextCmdnum;
	    if(  ( (h->nextCmdnum - cmdnum) > MaxHistCmds )
	       ||( cmdnum <= 0 )
	       ||( (h->nextCmdnum - cmdnum) <= 0 ) )
		return( -1 );	/* only remembers last 20 */
	    else
	      {
		j = h->nextCmd - (h->nextCmdnum - cmdnum) + MaxHistCmds;
		j = (j % MaxHistCmds);
	      }
	  }
	else		  
	  {
	    for (j = h->nextCmd - 1; j != h->nextCmd; j--)
	      {
		if (j == -1)
		    j = MaxHistCmds - 1;
		flag = 0;
		if (h->cmds[j] == NULL)
			    /* Haven't filled the whole history yet. */
		    break;
		s1 = lineBuf + i + 1;
		s2 = h->cmds[j];
		while (*s1++ == *s2++)
		    if ((*s1 == '\0') || (*s1 == ' '))
		      {
			flag = 1;
			break;
		      }
		if (flag)
		    break;
	      }
	    if (!flag)
			    /* Couldn't find the designated command. */
	      {
		return(-1);
	      }
	  }
	strcpy(lineBuf, h->cmds[j]);
	return(strlen(lineBuf));
      }
    else
      {
	h->nextCmdnum++;
	/* Save the command in the command history. */
	if (h->cmds[h->nextCmd] != NULL)
	    free(h->cmds[h->nextCmd]);
	h->cmds[h->nextCmd++] = strsave(lineBuf);
	if (h->nextCmd == MaxHistCmds)
	    h->nextCmd = 0;
	return(0);
      }
  }

/*
 * PrintHistory:
 * Print out the command history.
 */
PrintHistory(h, out)
    HistoryRec *h;
    File *out;
  {
    int j;
    int i;

    i = h->nextCmdnum - MaxHistCmds + 1;
    if( i <= 0 ) i = 1;

    j = h->nextCmd+1;
    if (j == MaxHistCmds) j = 0;
    while (j != h->nextCmd)
      {
	if (h->cmds[j] !=  NULL)
	  {
	    fprintf(out, "    %d  %s\n", i++, h->cmds[j]);
	  }
	if (++j == MaxHistCmds) j = 0;
      }
  }
