
/* V-System authentication server
 * Lance Berc 6-85
 * Based on previous work by Jorge Julio
 */
#define DEBUG

#include <Venviron.h>
#include <Vio.h>
#include <Vauthenticate.h>
#include <Vgroupids.h>

#define PASSWD "[sys]misc/Vpassword"
#define NAMETABLESIZE 31
#define UIDTABLESIZE 63

#define MAXSLAVES 20

typedef struct _HR
  {
    struct _HR *link; /* must be first */
    AuthRec *data;
  } HashRec;

extern char *malloc();
extern ProcessId Kernel_Process_Pid;

SystemCode WritePasswdFile();

HashRec *NameTable[NAMETABLESIZE+1];
HashRec *UIDTable[UIDTABLESIZE+1];
char *passwordfile;
char *master = NULL;
char *slaves[MAXSLAVES];
int slavecount = 0;

#ifdef DEBUG
int Debug = 0;
#endif
UID LastUID = 0;

ReturnAR( wf, req )
AuthRec *wf;
MsgStruct *req;
  {
    char buf[MAX_AUTH_REC];
    
    if (!artoa(wf, buf, req->segmentSize))
      {
        req->sysCode = BAD_BUFFER;
	return;
      }
req->sysCode = MoveTo(req->unspecified[1], req->segmentPtr,buf, strlen(buf)+1);
  }

UidCmp(a, b) AuthRec *a, *b; { return(a->uid - b->uid); }

NameCmp(a, b) AuthRec *a, *b; { return(strcmp(a->name, b->name)); }

AuthRec *Lookup(target, ptr, comparefunc)
register AuthRec *target;
register HashRec *ptr;
register int (*comparefunc)();
  {
    /* Search for the target authrec in a hash bucket. ptr is
     * the first hash entry in the chain.
     */
    register int cmp;
    
    while ( (ptr != NULL) && ((cmp = (*comparefunc)(ptr->data, target)) <= 0) )
      {
	if (cmp == 0) return( ptr->data );
	ptr = ptr->link;
      }
    return( NULL );
  }

Insert(newrec, ptr, comparefunc)
register AuthRec *newrec;
register HashRec *ptr;
int (*comparefunc)();
  {
    /* Add newrec to a hash bucket chain. ptr points to a pointer
     * the the first entry, not to the first entry !
     */
    register HashRec *tmp;

    while ( (ptr->link != NULL) &&
            ((*comparefunc)(ptr->link->data, newrec) < 0) )
	ptr = ptr->link;
    tmp = (HashRec *) malloc(sizeof(HashRec));
    tmp->data = newrec;
    tmp->link = ptr->link;
    ptr->link = tmp;
  }

Delete(oldrec, ptr)
register AuthRec *oldrec;
register HashRec *ptr;
  {
    /* Delete the hash bucket entry that is associated with the given
     * AuthRec. ptr points to a pointer to the first record, not to
     * the first record ! The AuthRec is assumed to be in the list.
     */
    register HashRec *tmp;
    
    while (ptr->link->data != oldrec) ptr = ptr->link;
    tmp = ptr->link;
    ptr->link = tmp->link;
    free(tmp);
  }

MapName(req, wf)
MsgStruct *req;
AuthRec *wf;
  {
    register AuthRec *rec;

    rec = Lookup(wf, NameTable[*wf->name & NAMETABLESIZE], NameCmp);
    if (rec != NULL ) ReturnAR( rec, req );
    else req->sysCode = NOT_FOUND;
  }

MapUid(req, wf)
MsgStruct *req;
AuthRec *wf;
  {
    register AuthRec *rec;

#ifdef DEBUG
if (Debug) printf("Mapping UID %d\n", wf->uid);
#endif
    rec = Lookup(wf, UIDTable[wf->uid & UIDTABLESIZE], UidCmp);
    if (rec != NULL )
	ReturnAR( rec, req );
    else req->sysCode = NOT_FOUND;
  }

AuthRec *ComparePasswd( req, wf )
MsgStruct *req;
AuthRec *wf;
  {
    register AuthRec *rec;

    rec = Lookup(wf, NameTable[*wf->name & NAMETABLESIZE], NameCmp);
    if (rec == NULL)
	req->sysCode = NOT_FOUND;
    else
	if ( ((*rec->passwd == 0) && (*wf->passwd == 0))  || 
	     (strcmp(crypt(wf->passwd, rec->passwd), rec->passwd) == 0) )
	    req->sysCode = OK;
	else req->sysCode = NO_PERMISSION;

#ifdef DEBUG
if (Debug && (req->sysCode != OK)) printf("%s password mismatch\n",wf->name);
#endif

    return( rec );
  }

Authenticate(req, wf)
MsgStruct *req;
AuthRec *wf;
  {
    register AuthRec *rec;

    rec = ComparePasswd( req, wf );
    if (req->sysCode == OK)
      {
	req->sysCode = SetUserNumber(req->unspecified[1], rec->uid);
#ifdef DEBUG
if (Debug)
  {
printf("Authenticating %x to %d [%x]\n", req->unspecified[1], rec->uid, req->sysCode);
if (User(req->unspecified[1]) != rec->uid) printf("Didn't set\n");
  }
#endif
      }
  }

InsertAuthRec(wf)
register AuthRec *wf;
  {
    register AuthRec *newrec;
    unsigned long time, i;
    char salt[2], c;
    
    newrec = (AuthRec *) malloc(sizeof(AuthRec));
    newrec->uid = wf->uid;
    newrec->name = malloc(strlen(wf->name)+1);
    newrec->fullname = malloc(strlen(wf->fullname)+1);
    newrec->home = malloc(strlen(wf->home)+1);
    strcpy(newrec->name, wf->name);
    strcpy(newrec->fullname, wf->fullname);
    strcpy(newrec->home, wf->home);

    if (*wf->passwd == 0)
      {
	newrec->passwd = malloc(1);
	*newrec->passwd = 0;
      }
    else
      {
	newrec->passwd = malloc(14); /* room for salt */
	/* use random salt - This code stolen from Berzerkley */
	GetTime(&time);
	salt[0] = time & 0x3f;
	salt[1] = (time * 32123) & 0x3f;
	for (i = 0; i<2; i++)
	  {
	    c = salt[i] + '.';
	    if (c > '9') c += 7;
	    if (c > 'Z') c += 6;
	    salt[i] = c;
          }
	strcpy(newrec->passwd, crypt(wf->passwd, salt));
      }

    Insert(newrec, &NameTable[*newrec->name & NAMETABLESIZE], NameCmp);
    Insert(newrec, &UIDTable[newrec->uid & UIDTABLESIZE], UidCmp);
  }	

ModifyUser(req, wf)
MsgStruct *req;
AuthRec *wf;
  {
    AuthRec *rec;
    UID uid;

    if ( (rec = Lookup(wf, UIDTable[wf->uid & UIDTABLESIZE], UidCmp)) == NULL)
	req->sysCode = NOT_FOUND;
    else if ( strcmp( wf->name, rec->name ) &&
          (Lookup(wf, NameTable[*wf->name & NAMETABLESIZE], NameCmp) != NULL))
      req->sysCode = DUPLICATE_NAME;
    else if ( ((uid = User(req->unspecified[1])) != rec->uid) &&
               (uid != SUPER_USER) )
	req->sysCode = NO_PERMISSION;
    else
      {
	Delete(rec, &NameTable[*rec->name & NAMETABLESIZE]);
	Delete(rec, &UIDTable[rec->uid & UIDTABLESIZE]);
	DestroyAuthRec(rec);
	free(rec);
	InsertAuthRec(wf);
	req->sysCode = WritePasswdFile();
      }
  }

AddUser(req, wf)
MsgStruct *req;
AuthRec *wf;
  {
    if ( User(req->unspecified[1]) != SUPER_USER )
      req->sysCode = NO_PERMISSION;
    else
    if (Lookup(wf, NameTable[*wf->name & NAMETABLESIZE], NameCmp) != NULL)
      req->sysCode = DUPLICATE_NAME;
    else
      {
	wf->uid = ++LastUID;
	
	InsertAuthRec(wf);
	
	req->sysCode = WritePasswdFile();
      }
  }

DeleteUser(req, wf)
MsgStruct *req;
AuthRec *wf;
  {
    AuthRec *doomed;

    if (User(req->unspecified[1]) != SUPER_USER)
        req->sysCode = NO_PERMISSION;
    else
if ((doomed = Lookup(wf,NameTable[*wf->name & NAMETABLESIZE],NameCmp)) == NULL)
        req->sysCode = NOT_FOUND;
    else
      {
	if (doomed->uid == SUPER_USER) return(NO_PERMISSION);
	Delete(doomed, &NameTable[*doomed->name & NAMETABLESIZE]);
	Delete(doomed, &UIDTable[doomed->uid & UIDTABLESIZE]);
	DestroyAuthRec(doomed);
	free(doomed);

	req->sysCode = WritePasswdFile();
      }
  }

SystemCode WritePasswdFile()
  {
    FILE *f;
    int i, j;
    register HashRec *ptr;
    char buf[MAX_AUTH_REC];
    char *fn;
    int slave;
    
    for (slave = -1; slave < slavecount; slave++)
      {
	if (slave < 0)
	  {
	    if (master == NULL) continue;
	    else fn = master;
	  }
	else
	    fn = slaves[slave];

	f = fopen(fn, "w");
	if (f == NULL)
	  {
	    if (slave < 0)
	      {
printf("*** authserver: Couldn't open master password file '%s'\n", fn);
		return( POWER_FAILURE );
	      }
	    printf("*** authserver: Couldn't open password file %s\n", fn);
	    continue;
	  }
#ifdef DEBUG
if (Debug) printf("Writing file %s\n", fn);
#endif

	if (master) fprintf(f, "master:%s\n", master);
	for (j = 0; j < slavecount; j++)
	    fprintf(f, "slave:%s\n", slaves[j]);

	for (i = 0; i <= NAMETABLESIZE; i++)
	    for (ptr = NameTable[i]; ptr != NULL; ptr = ptr->link)
	      {
		if (artoa(ptr->data, buf, MAX_AUTH_REC))
		    fprintf(f, "%s\n", buf);
	        else
	          {
	    	    printf("Couldn't write password entry for %s <%s>.\n",
		  	ptr->data->name, ptr->data->fullname);
	          }
	      }
	fclose(f);
      }
    return( OK );
  }

ReadPasswdFile()
  {
    char s[MAX_AUTH_REC];
    FILE *f;
    register AuthRec *wf;
    register int len;

#ifdef DEBUG
if (Debug) printf("Opening %s.\n", passwordfile);
#endif
    f = fopen(passwordfile, "r");
    if (f == NULL)
      {
        printf("*** authserver: Couldn't open password file.\n");
	return;
      }
    while (fgets(s, MAX_AUTH_REC, f) != NULL)
      {
        if ((len = strlen(s)) < 5) continue;

	s[len-1] = 0; /* get rid of newline character */
	  
	if (!strncmp(s, "master:", 7))
	  {
	    if (master)
	      {
		printf("*** authserver: Multiple master file: %s\n", s);
		printf("*** authserver: Using %s\n", master);
	      }
	    else
	      {
		master = malloc(strlen(s) - 6);
		strcpy( master, s + 7);
	      }
	  }
	else if (!strncmp(s, "slave:", 6))
	  {
	    if (slavecount == MAXSLAVES)
	      {
		printf("*** authserver: Too many slaves. Not using %s\n", s);
	      }
	    else
	      {
		slaves[slavecount] = malloc(strlen(s) - 5);
		strcpy(slaves[slavecount], s + 6);
		slavecount++;
	      }
	  }
	else
	  {
	    wf = (AuthRec *) malloc(sizeof(AuthRec));
	    atoar(wf, s);
	    Insert(wf, &NameTable[*wf->name & NAMETABLESIZE], NameCmp);
	    Insert(wf, &UIDTable[wf->uid & UIDTABLESIZE], UidCmp);
	
	    if (wf->uid > LastUID) LastUID = wf->uid;
	  }
      }
#ifdef DEBUG
if (Debug) printf("Password file read. Last uid = %d.\n", LastUID);
#endif
  }

SystemCode ReadSegment(req, s)
register MsgStruct *req;
register char *s; /* Assumed to be MAX_AUTH_REC long */
  {
    int ret;
    int size;
    register char *p;

    if (req->segmentSize > MAX_AUTH_REC)
	size = MAX_AUTH_REC;
    else
	size = req->segmentSize;
    if (!size) return(BAD_ARGS);

    ret = MoveFrom(req->unspecified[1], s, req->segmentPtr, size);
    if (ret != OK) return(ret);

    /* Make sure that there is a NULL somewhere in the segment */
    p = &s[size-1];
    while ( (p>s) && (*p != 0) ) p--;
    if (*p != 0) return( BAD_ARGS );

    return( OK );
  }

ServerLoop()
/* Main authentication server loop. Process requests as they come in.
 */
  {
    MsgStruct req;
    AuthRec wf;
    ProcessId pid;
    int FreeFlag;
    unsigned size;
    SystemCode op;
    char s[MAX_AUTH_REC];

    for(;1;)
      {
	size = MAX_AUTH_REC;
	pid = Receive(&req);
	
#ifdef DEBUG
if (Debug) printf("Processing (%x %x)\n", pid, req.sysCode);
#endif
	
	req.unspecified[1] = pid;
	op = req.sysCode;
	
	if ((req.sysCode = ReadSegment(&req, s)) != OK)
	  {
	    Reply(&req, pid);
	    continue;
	  }
	
	atoar(&wf, s);
	
	switch(op)
	  {
	    case MAP_USER_NUMBER: { MapUid(&req, &wf); break; }
	    case MAP_USER_NAME: { MapName(&req, &wf); break;}
	    case AUTHENTICATE: { Authenticate(&req, &wf); break; }
	    case MODIFY_USER: { ModifyUser(&req, &wf); break;}
	    case ADD_USER: { AddUser(&req, &wf); break; }
	    case DELETE_USER: { DeleteUser(&req, &wf); break; }
	    case PASSWORD: { ComparePasswd(&req, &wf); break; }
	    default: { req.sysCode = ILLEGAL_REQUEST; break; }
	  }
	
	Reply(&req, pid);

	DestroyAuthRec(&wf);
      }
  }

InitServer()
/* Check to see if there is an authentication server out there.
 * Authenticate ourselves.
 * Set our logical pid.
 * Initialize the password table.
 */
  {
    int pid;
    SystemCode r;
    KernelRequest msg;
    AuthRec wf;

#ifdef DEBUG
if (Debug) printf("Initializing server.\n");
#endif
    
    msg.pid = 0;
    msg.opcode = SET_USER_NUMBER;
    msg.length = SUPER_USER;
/** KLUDGE ALERT ** KLUDGE ALERT ** KLUDGE ALERT ** KLUDGE ALERT **/
    msg.unspecified[2] = 3141596;
    Send(&msg, Kernel_Process_Pid);
    if (User(0) != SUPER_USER)
      {
	printf("Couldn't change user number to SUPER_USER\n");
	exit(1);
      }

#ifndef TESTING
    msg.opcode = NO_OPERATION;
    if ((pid = Send(&msg, VAUTH_SERVER_GROUP)) != 0 && ValidPid(pid))
      {
	printf("An Authentication server is currently running (%8x).\n", pid);
	exit(1);
      }
#endif
    JoinGroup(VAUTH_SERVER_GROUP, 0);
    SetPid(AUTH_SERVER, 0, ANY_PID);	/* %%% temporary */

    ReadPasswdFile();
    
    wf.uid = SUPER_USER;
    if (Lookup(&wf, UIDTable[SUPER_USER & UIDTABLESIZE], UidCmp) == NULL)
      {
	/* No SUPER_USER entry ! Make one up. */
	wf.name = "superuser";
	wf.fullname = "Automatic super user";
	wf.home = "[sys]";
	wf.passwd = "";
	
	InsertAuthRec(&wf);
      }
  }

usage()
  {
    printf("Usage: authserver [-d] [-Ffile]\n");
    exit(1);
  }

main(argc, argv)
int argc;
char **argv;
  {
    passwordfile = PASSWD;
    while (argc > 1)
      {
	argv++; argc--;
	if (**argv != '-') usage();
	(*argv)++;
	switch (**argv)
	  {
	    case 'd':
#ifdef DEBUG
		Debug++;
		break;
#else DEBUG
		printf("Debugging not compiled into this version.\n");
		exit(1);
#endif
	    case 'F':
		passwordfile = (*argv)+1;
		break;
		
	    default: usage();
	  }
      }
    InitServer();
    ServerLoop();
  }
