/*
 * The V UNIX server: a V kernel and V server simulator for VAX/UNIX
 * that provides a subset of UNIX system services to SUN workstations
 * running the V distributed kernel.
 * Copyright (c) 1982 David R. Cheriton, all rights reserved.
 *
 * header file.
 * NOTE: that the "Instance" structures all start with the same structure
 *	 and the type specific information is appended to the end.
 * 	 FileInstance is the template for the first part.
 */


#define BLOCK_SIZE    1024	/* Efficient amount to read and write */
#define BUFFER_SIZE	4096	/* Size of internal buffer for reads and writes */
#define MAX_PROG_ARGC		128	/* Random number of arguments to allow*/
					/* in remote execution of program */
#define MAX_PROG_NAME_LEN	128	/* Length of file name to be executed */
#define MAX_PROG_ARGS_LEN	4096	/* Max length of args field in program*/
					/* execution req.  (<= BUFFER_SIZE) */

typedef short unsigned		InstanceType;
#define FILE_INSTANCE		0x0001
#define PROCESS_INSTANCE	0x0002
#define DIRECTORY_INSTANCE	0x0004
#define MMCONTEXT_INSTANCE	0x0008

struct _FI
  {
    struct _FI		*link;
    InstanceId		id;		/* File instance id */
    InstanceType	type;		/* FILE_INSTANCE */
    ProcessId		owner;		/* Owner process */
    char		*name;		/* full name of file */
    short unsigned	filetype;
    unsigned		lastblock;      /* Last block written */
    unsigned		nextblock;      /* Next block to be read */
    unsigned		blocksize;	/* Max. block size */
    short unsigned	lastbytes;
    int			unixfile;	/* returned by UNIX open or creat */
    char		clock;		/* LRU UNIX file desc recycling
					   algorithm */
  };

typedef struct _FI FileInstance;

/*
 * Process may have two instance descriptors that contain info about them.
 * One for writing and the other for reading.  In this case,
 * the 'state' of the process must be updated in both PD's when
 * a change occurs [see CheckProcesses].
 */
struct _PD
  {
    struct _PD		*link;		
    InstanceId		id;		/* Process instance id */
    InstanceType	type;		/* PROCESS_INSTANCE */
    ProcessId		owner;		/* Owner of this process */
    char		*name;		/* name of file running */
    short unsigned	filetype;	/* Type of process communication */
    unsigned		lastblock;      /* Last block written */
    unsigned		nextblock;      /* Next block to be read */
    unsigned		blocksize;	/* Max block size */
    short unsigned	lastbytes;
    ProcessId		pid;		/* UNIX process id */
    short unsigned	state;		/* Server's idea of the process state */
    unsigned		pipedesc;	/* UNIX fid for pipe to process */
    SystemCode		lastreply;	/* last reply to a Read or Write */
    char		*lastdata;	/* last data Read (or perhaps written)*/
    unsigned long	lastdatasize;	/* number of bytes in last data */
  };

typedef struct _PD ProcessInstance;

/* _PD.state codes */
#define	PD_RUNNING		0x0001
#define PD_DEAD			0x0002
#define PD_STOPPED		0x0003
#define PD_KILLED		0x0004
#define PD_AWAITING_DEATH	0x0005
 
struct _DI
  {
    struct _DI		*link;
    InstanceId		id;		/* File instance id */
    InstanceType	type;		/* FILE_INSTANCE */
    ProcessId		owner;		/* Owner process */
    char		*name;		/* name is a ptr to context name;
    					   thus, it should not be freed */
    short unsigned	filetype;
    unsigned		lastblock;      /* Last block written */
    unsigned		nextblock;      /* Next block to be read */
    unsigned		blocksize;	/* Max. block size */
    short unsigned	lastbytes;
    int			unixfile;	/* returned by UNIX open or creat */
    ContextPair		ctx;		/* ContextId of directory */
  };

typedef struct _DI DirectoryInstance;

struct _QIO
  {
    struct _QIO		*link;
    IoRequest		req;			/* Request pending */
    ProcessId		pid;			/* Requesting process */
    SystemCode		(*IOFunction)();	/* Function corresponding to
						    requestcode of 'req' */
  };

typedef struct _QIO	WaitingIOEntry;


/* Sessions are no longer V file instances, but each session does have a simple
 * descriptor that contains information specific to itself.
 */

struct _SD
  {
    struct _SD		*link;		
    ProcessId		Vpid;		/* V process id for the session */
    ProcessId		localpid;	/* UNIX process id for the session */
    int			uid;		/* user id of owner */
    int			gid;		/* group id of owner */
    long		logintime;	/* time of creation */
    int			inactivity;	/* Inactivity count, for terminating
					 * session */
  };

typedef struct _SD SessionDesc;
extern SessionDesc *Session;

/* "check modes" for ReclaimInstances() - these are mutually exclusive: */
#define RI_CHECK_ONLY	    0	/* Check each instance for validity, and free 
				   it if it's invalid, but do no more than
				   this. */
#define RI_FREE_DESCRIPTOR  1	/* Try to free a file descriptor, possibly by 
				   closing an already open file (LRU). */
#define RI_RELEASE_ALL	    2	/* Close all instances, even if valid. */
