/*
 * Some useful byte swapping macros
 */

#define ByteSwapLong(x)		\
     ( ((((unsigned)(x)) >> 24) & 0xFF) + ((((unsigned)(x)) >> 8) & 0xFF00) \
       + ((((unsigned)(x)) << 8) & 0xFF0000) + (((unsigned)(x)) << 24) )
#define ByteSwapShort( x )	\
     ( (((x) >> 8) & 0xFF) + (((x) << 8 ) & 0xFF00) )

#ifdef LITTLE_ENDIAN
#define LittleEndianizeShort(x)		x
#define BigEndianizeShort(x)		ByteSwapShort(x)
#else LITTLE_ENDIAN
#define LittleEndianizeShort(x)		ByteSwapShort(x)
#define BigEndianizeShort(x)		x
#endif LITTLE_ENDIAN
