/*
 * The V UNIX server: a V kernel and V server simulator for VAX/UNIX
 * that provides a subset of UNIX system services to SUN workstations
 * running the V distributed kernel.
 * Copyright (c) 1982 David R. Cheriton, all rights reserved.
 *
 *
 * Dynamic debugging definitions file.
 *
 * 
 */

extern long Debug;

#define DEBUG( mode ) ( (mode)&Debug )

/* bits of the Debug word that specify what to debug */
#define KERNEL_DEBUG		0x0001
#define GENERIC_DEBUG		0x0002
#define NET_DEBUG		0x0004
#define DIRECTORY_DEBUG		0x0008
#define CONTEXT_DEBUG		0x0010
#define FILE_DEBUG		0x0020
#define PROCESS_DEBUG		0x0040
#define INSTANCE_DEBUG		0x0080
#define SESSION_DEBUG		0x0100
#define LOOKUP_DEBUG		0x0200
#define MULTICAST_DEBUG		0x0400

#define KDebug		( DEBUG( KERNEL_DEBUG ) )
#define NDebug		( DEBUG( NET_DEBUG ) )
#define GDebug		( Debug )	/* general errors and the like */
#define DDebug		( DEBUG( DIRECTORY_DEBUG ) )
#define CDebug		( DEBUG( CONTEXT_DEBUG ) )
#define IDebug		( DEBUG( INSTANCE_DEBUG ) )
#define PDebug		( DEBUG( PROCESS_DEBUG ) )
#define FDebug		( DEBUG( FILE_DEBUG ) )
#define SDebug		( DEBUG( SESSION_DEBUG ) )
#define LDebug 		( DEBUG( LOOKUP_DEBUG ) )
#define MDebug 		( DEBUG( MULTICAST_DEBUG ) )
