/* fread, fwrite: hacked up for V -- Per Bothner, Feb 1983
 *
 * Bug fixed in reading small sizes in fread -- Bill Nowicki, April 1983
 * Made fread work when not in reading mode & commented -- Tim Mann, Sep 1983
 */

#include	"Vio.h"

fread(ptr, size, count, file)
    register size, count;
    register char *ptr;
    register File *file;
  {
    register c;
    register bufRem = file->readLimit - file->current;
	/* number of chars left in file->buffer */
    register unsigned char *bufptr = file->current;
	/* local pointer into file->buffer */
    register ndone, s;

    if (size <= 0) return (0);  /* consider this an error */

    ndone = 0;  /* number of items successfully read */
    /* For each item... */
    for (; ndone<count; ndone++)
      {
	s = size;  /* how much of the item is left to read */
	do
	  {
	    if (bufRem >= s)
	      {
		/* rest of the item is in the buffer */
		bufRem -= s;
		file->current += s;
		do *ptr++ = *bufptr++; while (--s > 0); break;
	      }
	    else
	      {
		if (bufRem > 0)
		  {
		    /* part of the item is in the buffer */
		    s -= bufRem;
		    file->current = file->readLimit;
		    do *ptr++ = *bufptr++; while (--bufRem > 0);
		  }
		/* read in the next block from the file */
		/* We also get here on the first iteration if file
		 *  wasn't in reading mode when we were called */
		if ((c = FillBuffer(file)) < 0) 
		    return (ndone); /* error on read (probably eof) */
		*ptr++ = c;
		bufptr = file->current;
		bufRem = file->readLimit - file->current;
	      }
	  } while (--s > 0); /* decr for char returned by FillBuffer */
      }
    return(ndone);
  }


/* this could be hacked like fread to make it faster */
fwrite(ptr, size, count, file)
    unsigned size, count;
    register unsigned char *ptr;
    register File *file;
  {
    register unsigned s;
    unsigned ndone;

    ndone = 0;
    if (size)
      {
	for (; ndone<count; ndone++)
	  {
	    s = size;
	    do
	      {
		putc(*ptr++, file);
	      } while (--s);
	    if( file->state & EOF_BYTE ) break;
	  }
      }
    return(ndone);
  }
