/*
 * freopen.c
 */
#include "Vioprotocol.h"

extern File *Open();

File *freopen( pathname, mode, fad )
   char *pathname; register char *mode; File *fad;

  /*  Freopen opens the file specified by pathname, positioning it for
   *   read, write, or append operations, depending on the contents
   *   of mode.
   *   Mode is specified as in Unix ("r", "w", "a", "r+", "w+", "a+"),
   *   with the exception that the V library provides no "write only"
   *   mode.  Thus "w" and "w+" are equivalent here.
   *   It then closes the file associated with fad and uses this
   *   descriptor for the new open file.
   */

{
    extern File *TeamFileList;
    Message Msg;
    register IoRequest *request = (IoRequest *)Msg;
    register File *p, *c;
    SystemCode error;
    register int readandwrite;
    File        *newfad;

    Flush( fad ); /* Flush file to be reopened. */

    /* Close the file before reopening it. */
    if ( fad->type & FRELEASE_ON_CLOSE )
      {
	request->requestcode = RELEASE_INSTANCE;
	request->fileid = fad->fileid;
	request->releasemode = OK;

	Send( request, fad->fileserver );
      }
    if ( fad->buffer && fad->fileserver ) free( fad->buffer );


   readandwrite =  mode[ 1 ] == '+';

   if( mode[ 0 ] == 'w' )
      {
       /*  If mode is "w", create a new instance of the file. FCREATE allows
        *  both reading from and writing to the file.
        */
        newfad = Open( pathname, FCREATE, &error );
      }
   else if( mode[ 0 ] == 'a' )
      {
        /*  If mode is "a", position the file at its end, for both reading and
         *  writing, or for writing only.
         */

	if( readandwrite )
	  {
	    newfad = Open( pathname, FMODIFY, &error );
	    if (error == OK) Seek( newfad, 0, FILE_END );
	  }
	else
	    newfad = Open( pathname, FAPPEND, &error );
      }
   else if( mode[ 0 ] == 'r' )
      {	
	/*  If the mode is "r", open the file for both reading and writing,
         *  or for reading only.
         */

	 if( readandwrite )
	      newfad = Open( pathname, FMODIFY, &error );
	 else
	      newfad = Open( pathname, FREAD, &error );
      }
   else
      {
         newfad = Open( pathname, FREAD, &error );
      }

    if (error != OK) return NULL;

    /* Copy the new file descriptor into fad, keeping link field intact. */
    p = fad->link;
    Copy( fad, newfad, sizeof(File) );
    fad->link = p;

    /* Free the new file descriptor */
    if ( newfad == TeamFileList ) TeamFileList = newfad->link;
    else
      {
	p = TeamFileList;
	while( ((c = p->link) != NULL ) && (c != newfad) ) p = c;
        if ( c == NULL ) return;

	p->link = c->link;
      }
    free( newfad );

    return( fad );
  }
