/************************************************************************/
/*									*/
/*			(C) COPYRIGHT 1983				*/
/*			BOARD OF TRUSTEES				*/
/*			LELAND STANFORD JUNIOR UNIVERSITY		*/
/*			STANFORD, CA. 94305, U.S.A.			*/
/*									*/
/************************************************************************/

/*
 * Routine to select servers from those registered with
 * the service server.
 */


#include <Vio.h>
#include "Vservice.h"


InstanceId CreateSelectionInstance(serverType, pattern, patternFcn, howMany,
				   desc, descLen, error)
    char *serverType;
    char *pattern;
    int patternFcn;
    int howMany;
    char *desc;
    int descLen;		/* Size of desc buffer. */
    SystemCode *error;
  {
    static ProcessId serviceServer = 0;
    int i, n;
    Message msg;
    SelectObjectsRequest *reqMsg = (SelectObjectsRequest *) msg;
    SelectObjectsReply *repMsg = (SelectObjectsReply *) msg;

    for (i = 0; i < 2; i++)
      {
	if (serviceServer == 0)
	  {
	    /* Locate the service server. */
	    serviceServer = GetPid(SERVICE_SERVER, ANY_PID);
	    if (serviceServer == 0)
	      {
		return(SERVER_NOT_RESPONDING);
	      }
	  }
    
	/* The server is unregistered by calling an ordinary release instance
	   on its server id (obtained when the server was registered). */
	reqMsg->requestcode = CREATE_SELECTION_INSTANCE;
	reqMsg->howMany = howMany;
	reqMsg->patternFcn = patternFcn;
	n = strlen(serverType);
	reqMsg->patternIndex = n;
	strcpy(desc, serverType);
	strcat(desc, pattern);
	reqMsg->bufferptr = desc;
	reqMsg->bytecount = descLen;
	Send(msg, serviceServer);
	if (repMsg->replycode != NONEXISTENT_PROCESS)
	  {
	    break;
          }
	serviceServer = 0;
      }
    *error = repMsg->replycode;
    return(repMsg->selectionId);
  }
