/************************************************************************/
/*									*/
/*			(C) COPYRIGHT 1983				*/
/*			BOARD OF TRUSTEES				*/
/*			LELAND STANFORD JUNIOR UNIVERSITY		*/
/*			STANFORD, CA. 94305, U.S.A.			*/
/*									*/
/************************************************************************/

/*
 * Routines to register/unregister an object with the service server.
 */


#include <Vioprotocol.h>
#include "Vservice.h"


InstanceId RegisterObject(nameType, nameIndex, typeIndex, 
			ownerPid, desc, descLen, error)
    int nameType;
    int nameIndex;
    int typeIndex;
    ProcessId ownerPid;
    char *desc;
    int descLen;
    SystemCode *error;
  {
    static ProcessId serviceServer = 0;
    int i;
    Message msg;
    RegisterObjectRequest *reqMsg = (RegisterObjectRequest *) msg;
    RegisterObjectReply *repMsg = (RegisterObjectReply *) msg;

    for (i = 0; i < 2; i++)
      {
	if (serviceServer == 0)
	  {
	    /* Locate the service server. */
	    serviceServer = GetPid(SERVICE_SERVER, ANY_PID);
	    if (serviceServer == 0)
	      {
		return(SERVER_NOT_RESPONDING);
	      }
	  }
    
	/* Register the server. */
	reqMsg->requestcode = REGISTER_OBJECT;
	reqMsg->nameType = nameType;
	reqMsg->nameIndex = nameIndex;
	reqMsg->typeIndex = typeIndex;
	reqMsg->ownerPid = ownerPid;
	reqMsg->bufferptr = desc;
	reqMsg->bytecount = descLen;
	Send(msg, serviceServer);
	if (repMsg->replycode == OK)
	  {
	    break;
          }
	serviceServer = 0;
      }
    *error = repMsg->replycode;
    return(repMsg->objectId);
  }


SystemCode UnregisterObject(serverId)
    InstanceId serverId;
  {
    static ProcessId serviceServer = 0;
    int i;
    Message msg;
    IoRequest *reqMsg = (IoRequest *) msg;

    for (i = 0; i < 2; i++)
      {
	if (serviceServer == 0)
	  {
	    /* Locate the service server. */
	    serviceServer = GetPid(SERVICE_SERVER, ANY_PID);
	    if (serviceServer == 0)
	      {
		return(SERVER_NOT_RESPONDING);
	      }
	  }
    
	/* The server is unregistered by calling an ordinary release instance
	   on its server id (obtained when the server was registered). */
	reqMsg->requestcode = RELEASE_INSTANCE;
	reqMsg->fileid;
	Send(msg, serviceServer);
	if (reqMsg->requestcode == OK)
	  {
	    break;
          }
	serviceServer = 0;
      }
    return(reqMsg->requestcode);
  }


InstanceId RegisterServer(nameType, nameIndex, typeIndex, 
			ownerPid, desc, descLen, error)
    int nameType;
    int nameIndex;
    int typeIndex;
    ProcessId ownerPid;
    char *desc;
    int descLen;
    SystemCode *error;
  {
    static ProcessId serviceServer = 0;
    int i;
    Message msg;
    RegisterObjectRequest *reqMsg = (RegisterObjectRequest *) msg;
    RegisterObjectReply *repMsg = (RegisterObjectReply *) msg;

    for (i = 0; i < 2; i++)
      {
	if (serviceServer == 0)
	  {
	    /* Locate the service server. */
	    serviceServer = GetPid(SERVICE_SERVER, ANY_PID);
	    if (serviceServer == 0)
	      {
		return(SERVER_NOT_RESPONDING);
	      }
	  }
    
	/* Register the server. */
	reqMsg->requestcode = REGISTER_OBJECT;
	reqMsg->nameType = nameType;
	reqMsg->nameIndex = nameIndex;
	reqMsg->typeIndex = typeIndex;
	reqMsg->ownerPid = ownerPid;
	reqMsg->bufferptr = desc;
	reqMsg->bytecount = descLen;
	Send(msg, serviceServer);
	if (repMsg->replycode == OK)
	  {
	    break;
          }
	serviceServer = 0;
      }
    *error = repMsg->replycode;
    return(repMsg->objectId);
  }


SystemCode UnregisterServer(serverId)
    InstanceId serverId;
  {
    static ProcessId serviceServer = 0;
    int i;
    Message msg;
    IoRequest *reqMsg = (IoRequest *) msg;

    for (i = 0; i < 2; i++)
      {
	if (serviceServer == 0)
	  {
	    /* Locate the service server. */
	    serviceServer = GetPid(SERVICE_SERVER, ANY_PID);
	    if (serviceServer == 0)
	      {
		return(SERVER_NOT_RESPONDING);
	      }
	  }
    
	/* The server is unregistered by calling an ordinary release instance
	   on its server id (obtained when the server was registered). */
	reqMsg->requestcode = RELEASE_INSTANCE;
	reqMsg->fileid;
	Send(msg, serviceServer);
	if (reqMsg->requestcode == OK)
	  {
	    break;
          }
	serviceServer = 0;
      }
    return(reqMsg->requestcode);
  }
