/************************************************************************/
/*									*/
/*			(C) COPYRIGHT 1983				*/
/*			BOARD OF TRUSTEES				*/
/*			LELAND STANDFORD JUNIOR UNIVERSITY		*/
/*			STANFORD, CA. 94305, U.S.A.			*/
/*									*/
/************************************************************************/

/*
 * Routines to update/return the current status of the host with respect to
 * things like availability for remote execution, etc.
 *
 * Marvin Theimer, 12/4/83.
 *	First written.
 */


#include <Vio.h>
#include <Vteams.h>



/*
 * UpdateHostStatus:
 * Update host status kept by team server.
 */

SystemCode UpdateHostStatus(userName, availability)
    char *userName;
    int availability;
  {
    Message msg;
    UpdateHostStatusRequest *reqMsg = (UpdateHostStatusRequest *) msg;
    ProcessId teamServerPid;

    teamServerPid = GetPid(TEAM_SERVER, LOCAL_PID);
    if (teamServerPid == 0)
      {
	return(SERVER_NOT_RESPONDING);
      }
    reqMsg->requestcode = UpdateRequest;
    reqMsg->requesttype = UpdateInformation;
    reqMsg->availability = availability;
    reqMsg->bufferptr = userName;
    reqMsg->bytecount = strlen(userName) + 1;
    teamServerPid = Send(msg, teamServerPid);
    return(reqMsg->requestcode);
  }


/*
 * ReturnHostStatus:
 * Return host status kept by team server.
 */

SystemCode ReturnHostStatus(userName, availability, maxUserNameSize)
    char *userName;
    int *availability;
    int maxUserNameSize;	/* Specifies max size that userName string
				   may be. */
  {
    Message msg;
    UpdateHostStatusRequest *reqMsg = (UpdateHostStatusRequest *) msg;
    ProcessId teamServerPid;

    teamServerPid = GetPid(TEAM_SERVER, LOCAL_PID);
    if (teamServerPid == 0)
      {
	return(SERVER_NOT_RESPONDING);
      }
    reqMsg->requestcode = UpdateRequest;
    reqMsg->requesttype = ReturnInformation;
    reqMsg->bufferptr = userName;
    reqMsg->bytecount = maxUserNameSize;
    teamServerPid = Send(msg, teamServerPid);
    if (reqMsg->requestcode != OK)
      {
	return(reqMsg->requestcode);
      }
    *availability = reqMsg->availability;
    return(reqMsg->requestcode);
  }
