
printf(string)
  char *string;
  {
    register int *argp = (int *) &string;
    register char *s = string;
    register int c;

    argp++;
    while(*s)
      {
	if (*s == '%')
	  {
	    s++;
	    switch(*s++)
	      {
	      case 's': puts(*argp++);  break;
	      case 'x': hexprint(*argp++);  break;
	      case 'd': decprint(*argp++);  break;
	      case 'o': octprint(*argp++);  break;
	      case 'c': 
		c = *argp++;
		K_putchar(c);
		break;
	      default:
		K_putchar(*(s-2));
		K_putchar(*(s-1));
	      }
	  }
	else K_putchar(*s++);
      }
  }


/* unsigned hexadecimal print */
hexprint(n)
  register unsigned n;
  {
    register unsigned i, digit, pflag = 0;

    for (i=0; i<8; i++)
      {
	digit = (n >> 28);
	if (digit != 0 || i == 7) pflag = 1;
	if (pflag) 
	  {
	    if (digit > 9) digit += 'a'-10;
	    else digit += '0';
	    K_putchar(digit);
	  }
	n <<= 4;
      }
  }


/* Unsigned octal print.  We build the character string backwards. */
octprint(n)
  register unsigned n;
  {
    register unsigned digit;
    static char octbuf[14];
    register char *p = octbuf+13;

    *p-- = 0;
    if (n==0)  { K_putchar('0'); return; }
    while (n != 0)
      {
	digit = n & 07;
	n >>= 3;
	*p-- = digit + '0';
      }
    p++;
    puts(p);
  }


/* Signed decimal print.  We build the character string backwards. */
decprint(n)
  register int n;
  {
    register unsigned digit, nflag=0;
    static char decbuf[12];
    register char *p = decbuf+11;

    *p-- = 0;
    if (n<0)   { n = -n; nflag++; }
    if (n==0)  { K_putchar('0'); return; }
    while (n != 0)
      {
	digit = n % 10;
	n = n / 10;
	*p-- = digit + '0';
      }
    if (nflag) *p-- = '-';
    p++;
    puts(p);
  }
