/*
 * rawio.c
 *
 * This used to be emt.c, the file which contains raw io routines for the
 * uvax.  It is logically equivalent to rawio.c in ../m68k and ../ff68k,
 * which used to call this fakeemt.c.
 *
 */

#include "ipl.h"

/*
 * K_putchar
 * Prints the character c on the console.
 */
K_putchar( c )
    int c;
  {
    register int r11;	/* the first variable declared register is */
			/* allocated by the compiler to be r11, I believe. */
    int i;

    if (c == '\n')
      {
	for( i = 0; i < 1000; i++ );
	K_putchar('\r');
	for( i = 0; i < 1000; i++ );
      }
	
    asm("	mfpr	$txcs, r11");
    while( !(r11 & 0x80) )
      {
	;asm("	mfpr	$txcs, r11");
      }
    r11 = c & 0377;
    asm("	mtpr	r11, $txdb");
    asm("	mfpr	$txcs, r11");
    while( !(r11 & 0x80) )
      {
	;asm("	mfpr	$txcs, r11");
      }
  }

/*
 *	Get a character c from the console
 */
int K_mayget()
  {
    register int r11;

    ;asm("	mfpr	$rxcs, r11");	/* check controller status */
    if ( !(r11 & 0x80) ) return( -1 );
#ifdef undef
    /* Zero may not be a reasonable thing to return, but at least it returns
     * something.
     */
    if ( r11 & 0xff00 ) return( 0 );	/* check for break or errors */
#endif
    ;asm("	mfpr	$rxdb, r11");	/* return character in buffer */
    r11 &= 0x7f;			/* Mask off parity and error bits */
    return( r11 );
  }

/*
 * K_getchar:
 * Busy waits for a character to be typed in from the keyboard and returns it.
 */
unsigned char K_getchar()
  {
    register int c;

    while ( (c = K_mayget()) == -1);
    return((unsigned char) (c & 0xff));
  }

K_puts( str )
register unsigned char *str;
  /* Output a string busy wait on the console from the kernel.
   */
  {
    register unsigned char c;

    while( c = *str++ ) K_putchar( c );
  }
