/*
 * Sun MC68000 ROM monitor Emulator Trap package
 *
 * CRZ 8/24/85 All of the routines in this file have been consolodated
 * from all of the previous files in which thry resided.  They have
 * not been modified, but have merely been copied into this one
 * file.  This has been done to ease the understanding of the
 * parallel structure of rawio routines for sun1 m68k, sun2 m68k,
 * ff68k, and the uvax, as well as promote organization in general.
 *
 */

#include <sunemt.h>

static int linereadyrx(), lineget();

/* This was emtcall.c */
/*
 * K_call.c
 *
 * Sun MC68000 ROM monitor Emulator Trap package
 *
 * int K_call(traptype[,arg1[,arg2[,arg3]]])
 *	emulator trap calling routine
 */

int K_call(trtype,trarg1,trarg2,trarg3)
    int trtype;
    int trarg1;
    int trarg2;
    int trarg3;
  {
    asm("	movl a6@(20.),sp@-");
    asm("	movl a6@(16.),sp@-");
    asm("	movl a6@(12.),sp@-");
    asm("	movl a6@(8.),sp@-");
    asm("	trap #15.");
    asm("	addql #8.,sp");
  }

/* This was emtgetchar.c */
/*
 * K_getchar.c
 *
 * Sun MC68000 ROM monitor Emulator Trap package
 *
 * char K_getchar()	-- returns character read from console keyboard
 */

static int done_setecho = 0;

char K_getchar()
  {
    if (!done_setecho)
      {
	/*
	 * Ensure that echoing is turned off, since that's the default
	 *   behaviour we want but not the default behaviour we experience
	 *   (why, all of a sudden?).
	 */
	K_call( EMT_SETECHO, 0 );
	done_setecho = 1;
      }
    return( K_call( EMT_GETCHAR ) );
  }

/* This was emtputchar.c */
/*
 * K_putchar.c
 *
 * Sun MC68000 ROM monitor Emulator Trap package
 *
 * int K_putchar(c)	-- prints character c on Console
 */

int K_putchar(c)
    char c;
  {
    return( K_call( EMT_PUTCHAR, c ) );
  }

K_puts( s )
register char *s;
  {
    while ( *s ) K_call( EMT_PUTCHAR, *s++ );
  }

/*This was getcontext.c */
/*
 * getcontext.c
 *
 * Sun MC68000 ROM monitor Emulator Trap package
 *
 * int K_getcontext()	-- returns current context register contents
 */

int K_getcontext()
  {
    return( K_call( EMT_GETCONTEXT ) );
  }

/* This was getmemsize.c */
/*
 * getmemsize.c
 *
 * Sun MC68000 ROM monitor Emulator Trap package
 *
 * int K_getmemsize()	-- returns on-board memory size in bytes
 */

int K_getmemsize()
  {
    return( K_call( EMT_GETMEMSIZE ) );
  }

/* This was getsegmap.c */
/*
 * getsegmap.c
 *
 * Sun MC68000 ROM monitor Emulator Trap package
 *
 * int K_getsegmap(cxt,segno)	-- 
 *	returns segment map entry #segno in context #cxt
 */

int K_getsegmap(cxt,segno)
  {
    return( K_call( EMT_GETSEGMAP, cxt, segno ) );
  }

/* This was setcontext.c */
/*
 * setcontext.c
 *
 * Sun MC68000 ROM monitor Emulator Trap package
 *
 * int K_setcontext(cxt)	-- sets context register to cxt
 */

int K_setcontext(cxt)
    int cxt;
  {
    return( K_call (EMT_SETCONTEXT, cxt ) );
  }

/* This was setecho.c */
/*
 * setecho.c
 *
 * Sun MC68000 ROM monitor Emulator Trap package
 *
 * setecho(flag) -- sets console echo mode:
 *		if (flag) then echo; else dont't echo;
 */

setecho(flag)
    int flag;
  {
    done_setecho = 1;
    return( K_call( EMT_SETECHO, flag ) );
  }

/* This was setsegmap.c */
/*
 * setsegmap.c
 *
 * Sun MC68000 ROM monitor Emulator Trap package
 *
 * int K_setsegmap(cxt,segno,entry)	-- 
 *	sets segment map #segno in context #cxt to entry
 */

int K_setsegmap( cxt, segno, entry )
    int cxt;
    int segno;
    int entry;
  {
    return( K_call( EMT_SETSEGMAP, cxt, segno, entry ) );
  }

/* This was ticks.c */
/*
 * ticks.c
 *
 * Sun MC68000 ROM monitor Emulator Trap package
 *
 * int K_ticks()	-- returns milliseconds since monitor booted
 */

int K_ticks()
  {
    return( K_call( EMT_TICKS )	);
  }

/* This was version.c */
/*
 * version.c
 *
 * Sun MC68000 ROM monitor Emulator Trap package
 *
 * int K_version()	-- returns monitor version number
 */

int K_version()
  {
    return( K_call( EMT_VERSION ) );
  }

/* This was getconfig.c */
/* LINTLIBRARY */
/*
 * K_getconfig.c
 *
 * Sun MC68000 ROM monitor Emulator Trap package
 *
 * int K_getconfig()	-- returns processor board configuration
 */

int K_getconfig()
  {
    return( K_call( EMT_GETCONFIG ) );
  }

/* This was fbmode.c */
/*
 * fbmode.c
 *
 * Sun MC68000 ROM monitor Emulator Trap package
 *
 * fbmode(mode) -- sets/queries monitor's frame buffer mode:
 *
 * INPUT:	flag = 1 or -1 => set FB mode to flag (unless FBmode == 0)
 *		flag = <other>	=> no side effects
 * OUTPUT:	1 = using FB
 *		0 = no fb present
 *		-1 = fb present but not in use
 *		
 */

fbmode( mode )
    int mode;
  {
    return( K_call( EMT_FBMODE, mode ) );
  }

/* This was mayget.c */
/*
 * mayget.c
 *
 * Sun MC68000 ROM monitor Emulator Trap package
 *
 * char K_mayget()	-- returns character read from console keyboard
 *			   if one is there, else -1 (nonblocking getchar)
 */

char K_mayget()
  {

/* the proper way
    return( K_call( EMT_MAYGET ) );
*/

/* the improper way, will do till EMT_MAYGET is installed. */

    if (*(short *)0x400000 == 0x5375)  /* if SMI */
	return( K_call( EMT_MAYGET ) );
    else if( !linereadyrx(0) )
	return( -1 );
    else
	return( lineget(0)&127 );
  }

/* This was proctype.c */
/*
 * proctype.c
 *
 * Sun MC68000 ROM monitor Emulator Trap package
 *
 * int K_proctype()	-- returns a number corresponding the the 
 *   	    	    	   type of processor used in the system.
 */

int K_proctype()
  {
    return( K_call( EMT_PROCTYPE ) );
  }

#define linedata(line) *((char*)DEVADR+DATA+line*SEP)
#define linecontrol(line) *((char*)DEVADR+CONT+line*SEP)

#define DEVADR 0x600000
#define DATA 0
#define CONT 2
#define SEP  4
#define READYRX 1

static int lineget(line)
 {
  return linedata(line);
 }

static int linereadyrx(line)
 {
   return linecontrol(line)&READYRX;
 }

