/*
 * ready.c
 *
 * DESCRIPTION
 * The Ready function.  Goes along with the three other machine independent
 * functions in ../mi/create.c.  This one is machine dependent because we
 * need to set up the stack frame so that the function that starts
 * executing looks like it was called.
 *
 * EXPORTS
 * Ready(pid, n, a1, ..., an)		--Start it running
 *
 * IMPORTS
 * malloc, various kernel primitives
 * Suicide
 *
 * AUTHOR
 * Tim Mann
 *
 * HISTORY
 * 03/12/82 TPM - Initial version
 * 04/16/84 JHS - Changed to work with VAX
 */

#include "Vio.h"
#include "Vprocess.h"

/* Ready:
 *
 * Sets up arguments on a newly created process's stack, and adds
 *  the process to the ready queue by replying to it.  Returns zero
 *  if the process couldn't be replied to.
 * The first argument is the process id, the second is a count of
 *  the number of arguments to be passed to the child process, and
 *  the third and following contain the arguments.
 */
Ready(child, nargs, firstarg)
ProcessId child;
short nargs;
long firstarg;
  {
    Processor_state childState;
    long *stackPtr;
    int Suicide();
    Message msg;
    long *argp;
    short i;
    int	StartChild();
    
    if (ReadProcessState(child, &childState) == 0) return (0);
    stackPtr = (long *) childState.USER_STACK_POINTER;

    /* Stack up the arguments */
    argp = &firstarg + nargs;
    for ( i = nargs; i>0 ; i--)
      {
	*--stackPtr = *--argp;
      }
    
    *--stackPtr = (long)childState.pc;
    *--stackPtr = nargs;

    childState.pc = (Unspec) StartChild;
    childState.USER_STACK_POINTER = (Unspec) stackPtr;
    if (WriteProcessState(child, &childState) == 0) return (0);

    /* Reply to it */
    ((MsgStruct *) msg)->sysCode = OK;
    if (Reply(msg, child) == 0) return(0);

    return (child);

  }

/*
 * Here is the gross stuff.  When Create/Ready get called, they set up
 * for the routine StartChild to execute (it does not get called).
 * Ready will have pushed the arguments it wants to pass to the child
 * process on the stack, in addition to the routine that should start
 * executing and the number of arguments.  StartChild calls the routine,
 * so that a decent stack frame gets set up for it, and if the routine
 * ever returns, it calls Suicide.
 *
 * call akin to: StartChild(numargs, fn, arg1, ..., argn), except that
 * it's not called, it is jumped to.
 */

asm("	.text");
asm("	.align 2");
asm("_StartChild:");
asm("	clrq	ap");	/* Clear ap and fp, so stackdump routines can   */
			/*   see clearly where the stack ends.  Seemed  */
			/*   to work anyway, but it's nice to know why. */
asm("	calls	(sp)+, *(sp)+");
asm("	calls	$0, _Suicide");
