/*
 * Copyright (c) 1983 by Stanford University, all rights reserved.
 * V Kernel Interface
 *
 * 	CreateGroup
 */

#include "Venviron.h"

SystemCode QueryProcessorUsage( pid, usage, tusage )
    ProcessId pid; unsigned *usage, *tusage;
    /* Return the processor usage in "clicks" by the specified
     * process in *usage and return total for team in *tusage if
     * tusage is non-zero.
     * The function itself returns a replycode indicating success
     * or otherwise.
     */
  {
    Message msg;
    KernelRequest *req = (KernelRequest *) msg;
    extern Process_id Kernel_Process_Pid;

    req->opcode = QUERY_PROCESSOR_USAGE;
    req->pid = pid;
    req->unspecified[0] = (unsigned) tusage;
    
    Send( req, Kernel_Process_Pid );
    if( req->opcode != OK ) return( req->opcode );
    *usage = req->length;
    if( tusage ) *tusage = req->unspecified[0];

    return( OK );    
  }
