/*
 * Library routine to invoke the QueryKernel operation
 *
 * QueryKernel(pid, groupSelect, reply)
 *   pid -- Any valid process id running under the kernel that is
 *	to be queried, or 0 for the invoking process's kernel.
 *   groupSelect -- One of the codes defined in Vquerykernel.h to
 *	select which group of parameters or statistics is returned.
 *   reply -- Pointer to a message buffer to receive the reply.
 *	The type of the reply depends on the value of groupSelect.
 */

#include <Venviron.h>
#include <Vquerykernel.h>

extern ProcessId Kernel_Process_Pid;

QueryKernel(pid, groupSelect, reply)
    ProcessId pid;
    int groupSelect;
    Message reply;
  {
    register QueryKernelRequest *req = (QueryKernelRequest *) reply;

    req->requestcode = QUERY_KERNEL;
    req->groupSelect = groupSelect;
    req->pid = pid;

    Send(req, Kernel_Process_Pid);

  }
