/*
 * create.c
 *
 * A convenient interface to the kernel's process creation mechanism.
 *
 * EXPORTS
 * pid = Create(priority, fn, ss)	--Create a process
 */

#include "Vio.h"
#include "Vprocess.h"

char *LastStackAllocated;
extern char *strsave();

/* Create:
 *
 * Creates a process executing the function fn, with stack size
 *   ss.  The process is NOT started at this time.  The function
 *   fn may take arguments; these are set up by Ready at the time
 *   a process is started.
 * Returns the pid of the created process, or zero if the process
 *   cannot be created or there is no memory left for the stack.
 */
ProcessId Create(priority, fn, ss)
int (*fn)(), ss;
short priority;
  {
    ProcessId child;
    char *stackLimit;
    long *stackTop;
    Processor_state childState;
    PerProcessArea *childPerProcess;

    ss += ss & 1;	/* Round ss up to next even size */
    LastStackAllocated = stackLimit = (char *) malloc(ss);
    if (stackLimit == NULL) return (0);
    stackTop = (long *) (stackLimit + ss);

    child = CreateProcess(priority, 0, 0);

    if (ReadProcessState(child, &childState) == 0) return (0);
    childState.USER_STACK_POINTER = (Unspec) stackTop;
    childState.perProcess = (Unspec *) stackLimit;
    childState.perProcessLoc = (Unspec **) &PerProcess;
    childState.pc = (Unspec) fn;
    if (WriteProcessState(child, &childState) == 0) return (0);

    /* Initially, give child the same standard io, etc., as its creator */
    childPerProcess = (PerProcessArea *) childState.perProcess;
    *childPerProcess = *PerProcess;
    childPerProcess->stackSize = ss;
    childPerProcess->ctxname = strsave(childPerProcess->ctxname);

    return (child);
  }

