/************************************************************************/
/*									*/
/*			(C) COPYRIGHT 1983				*/
/*			BOARD OF TRUSTEES				*/
/*			LELAND STANFORD JUNIOR UNIVERSITY		*/
/*			STANFORD, CA. 94305, U.S.A.			*/
/*									*/
/************************************************************************/

/*
 * Circular, doubly-linked list manipulation package.
 *
 * Marvin Theimer, 11/25/83
 *	First written.
 */


#include <Vio.h>
#include "package.h"




/*
 * NOTE:
 * The list consists of a header record which points to the first item in
 * the list and item records which have next and prev pointers linking
 * themselves together in a circle (excluding the header).
 */


char *InitCList(list)
  {
    GenHdrRec *list;

    list = (GenHdrRec *) malloc(sizeof(GenHdrRec));
    list->head = NULL;
    list->tail = NULL;
    return((char *)list);
  }


int EmptyCList(list)
    GenHdrRec *list;
  {
    if (list->head == NULL)
      {
	return(TRUE);
      }
    else
      {
	return(FALSE);
      }
  }


AddCList(list, loc, item)
    GenHdrRec *list;
    GenRec *loc;		/* loc points to item AFTER which to insert.
				   loc == list implies insert at front. */
    GenRec *item;
  {
    if (list->head == NULL)
      {
	item->next = item->prev = item;
	list->head = list->tail = item;
	return;
      }
    if (loc == (GenRec *)list)
      {
        loc = list->head;
	list->head = item;
      }
    item->next = loc->next;
    item->prev = loc;
    loc->next = item;
    item->next->prev = item;
  }


GenRec *RemoveCList(list, loc)
    GenHdrRec *list;
    GenRec *loc;		/* loc points to record to remove. */
  {
    if (loc == list->head)
      {
	list->head = loc->next;
	if (list->head == loc)
	  {
	    list->head = NULL;
	  }
      }
    loc->prev->next = loc->next;
    loc->next->prev = loc->prev;
    loc->next = NULL;
    loc->prev = NULL;
    return(loc);
  }


char *FirstCList(list)
    GenHdrRec *list;
  {
    return((char *)list->head);
  }


char *LastCList(list)
    GenHdrRec *list;
  {
    if (list->head == NULL)
      {
	return(NULL);
      }
    return((char *)list->head->prev);
  }


/*
 * Iterator used to traverse the list from front to end, using NULL as
 * the termination signal.
 */

char *IterCList(list, loc)
    GenHdrRec *list;
    GenRec *loc;
  {
    loc = loc->next;
    if (loc == list->head)
      {
	return(NULL);
      }
    return((char *)loc);
  }
