/*
 * UndefineLocalName()
 * Removes the definition of a local alias for a context
 *   from the local name cache.
 *
 * Tim Mann 8-21-85
 */

#include "Vnaming.h"
#include "Vgroupids.h"
#include "Vnamecache.h"

extern NameCacheEntry *NameCacheLookup();
extern SystemCode NameCacheDelete();

SystemCode UndefineLocalName(name)
    char *name;
  {
    SystemCode err;
    register NameCacheEntry *ce;
    static ContextPair rootcontext =
	 { VCSNH_SERVER_GROUP, GLOBAL_ROOT_CONTEXT } ;

    ce = NameCacheLookup(name, rootcontext);

    if ( ce == NULL || !(ce->flags&ALIAS) )
	return NOT_FOUND;
    else
	return NameCacheDelete(ce);
  }
