/*
 * setenv.c
 *
 * Set the value of an environment variable.  If value==NULL, the
 *  variable becomes undefined.
 * The strings passed are copied to newly allocated memory.
 * Note that this routine has a small memory leak.  Every time you undefine
 *  or redefine a name, the memory used to hold its old value is
 *  lost.  It can't be freed because someone could have a pointer to it.
 */

#include "Vnamecache.h"
#include "Vio.h"

extern char *strsave();

setenv(name, value)
  {
    register EnvironmentVariable *ev, *prev;

    prev = (EnvironmentVariable *) PerProcess->env;
    ev = *PerProcess->env;
    
    /* See if currently defined; fall out 
     *  with ev==NULL if undefined */
    while (ev)
      {
	if (strcmp(name, ev->name) == 0)
	  {
	    /* Defined */
	    break;
	  }
	prev = ev;
	ev = ev->next;
      }

    /* Defining or undefining? */
    if (value)
      {
        /* Defining */
	if (ev)
	  {
	    /* Previously defined, reuse old record.
	     *  Can't free old value since someone 
             *  could have a pointer to it */
	    ev->value = strsave(value);
	  }
	else
	  {
	    /* Previously undefined, allocate new record */
	    ev = (EnvironmentVariable *) malloc(sizeof(EnvironmentVariable));
	    ev->name = strsave(name);
	    ev->value = strsave(value);

	    /* Link in */
	    ev->next = *PerProcess->env;
	    *PerProcess->env = ev;
	  }
      }
    else
      {
        /* Undefining */
	if (ev)
	  {
	    /* Unlink */
	    prev->next = ev->next;
	    
	    /* Free old record */
	    free(ev->name);
	    /* Can't free old value since someone 
	     *  could have a pointer to it */
	    free(ev);
	  }
      }
  }
